<?php declare(strict_types = 1);

namespace Core\Model\Helpers;

use Nette\Utils\Json;

class Ares
{
	public function findByIco(string $ico): ?array
	{
		$curl = curl_init();

		curl_setopt_array($curl, [
			CURLOPT_URL            => 'https://ares.gov.cz/ekonomicke-subjekty-v-be/rest/ekonomicke-subjekty/' . $ico,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING       => '',
			CURLOPT_MAXREDIRS      => 10,
			CURLOPT_TIMEOUT        => 60,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST  => 'GET',
		]);

		$response = curl_exec($curl);

		curl_close($curl);

		if (!is_string($response)) {
			return null;
		}

		$data = Json::decode($response, Json::FORCE_ARRAY);

		if (isset($data['kod'], $data['popis'])) {
			return null;
		}

		$street = $data['sidlo']['nazevUlice'] ?: $data['sidlo']['nazevCastiObce'] ?: $data['sidlo']['nazevObce'];

		if ($data['sidlo']['cisloDomovni']) {
			$street .= ' ' . $data['sidlo']['cisloDomovni'];
		}

		if ($data['sidlo']['cisloOrientacni']) {
			$street .= '/' . $data['sidlo']['cisloOrientacni'];
		}

		return [
			'ico'     => $ico,
			'dic'     => $data['dic'],
			'company' => $data['obchodniJmeno'],
			'street'  => $street,
			'city'    => $data['sidlo']['nazevSpravnihoObvodu'] ?: $data['sidlo']['nazevObce'],
			'zip'     => (string) $data['sidlo']['psc'],
		];
	}
}
