<?php declare(strict_types = 1);

namespace Core\Model\Helpers;

use Exception;
use Nette\Utils\DateTime;
use Nette\Utils\FileSystem;

class CoreHelper
{
	protected static ?bool $isCompiled = null;

	public static function isCompiled(): bool
	{
		if (self::$isCompiled === null) {
			self::$isCompiled = file_exists(TMP_DIR . '/compiled');
		}

		return self::$isCompiled;
	}

	public static function setCompiled(): void
	{
		if (!self::isCompiled()) {
			FileSystem::write(TMP_DIR . '/compiled', (string) time());
		}
	}

	public static function getLastSystemUpdate(): ?DateTime
	{
		$time = @file_get_contents(DATA_DIR . DS . 'core' . DS . 'lastSystemUpdate');
		try {
			if ($time) {
				return DateTime::from(trim($time));
			}
		} catch (Exception $e) {
		}

		return null;
	}

	public static function ipPrefix(string $ip): string
	{
		if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4)) {
			return implode('.', array_slice(explode('.', $ip), 0, 2));
		}
		if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV6)) {
			return substr($ip, 0, 8);
		}

		return '';
	}

	public static function getCurrentUrl(): string
	{
		$protocol = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? 'https' : 'http';
		$host     = $_SERVER['HTTP_HOST'] ?? 'localhost';
		$uri      = $_SERVER['REQUEST_URI'] ?? '';

		return $protocol . '://' . $host . $uri;
	}

	public static function getUserIpAddress(): string
	{
		$ipKeys = [
			'HTTP_CF_CONNECTING_IP',
			'HTTP_X_REAL_IP',
			'HTTP_CLIENT_IP',
			'HTTP_X_FORWARDED_FOR',
			'HTTP_X_FORWARDED',
			'HTTP_X_CLUSTER_CLIENT_IP',
			'HTTP_FORWARDED_FOR',
			'HTTP_FORWARDED',
			'REMOTE_ADDR',
		];

		foreach ($ipKeys as $key) {
			if (!empty($_SERVER[$key])) {
				$ipList = explode(',', $_SERVER[$key]);
				foreach ($ipList as $ip) {
					$ip = trim($ip);
					if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE)) {
						return $ip;
					}
				}
			}
		}

		return $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
	}

}
