<?php declare(strict_types = 1);

namespace Core\Model\Helpers\Traits;

use Core\Model\Entities\ExtraField;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\Common\Collections\Criteria;
use Doctrine\ORM\Mapping as ORM;

trait TExtraField
{
	protected ?array $cExtraFieldsByKey = null;

	protected ?array $cExtraFieldsValues = null;

	/**
	 * @var Collection<ExtraField>
	 */
	#[ORM\OneToMany(mappedBy: 'sectionKey', targetEntity: ExtraField::class, indexBy: 'key')]
	protected Collection $extraFields;

	public function fillExtraField(ExtraField $extraField): void
	{
		$extraField->sectionKey  = (string) $this->getId();
		$extraField->sectionName = self::EXTRA_FIELD_SECTION;
	}

	/**
	 * @return ArrayCollection
	 */
	public function getExtraFields()
	{
		if ($this->extraFields === null) {
			$this->extraFields = new ArrayCollection();
		}

		$criteria = Criteria::create()
			->where(Criteria::expr()->eq('sectionName', self::EXTRA_FIELD_SECTION));

		return $this->extraFields->matching($criteria);
	}

	/**
	 * @return ExtraField[]|ExtraField[][]
	 */
	public function getExtraFieldsByKey(): array
	{
		if ($this->cExtraFieldsByKey === null) {
			$this->cExtraFieldsByKey = [];

			foreach ($this->getExtraFields()->toArray() as $v) {
				if ($v->lang)
					$this->cExtraFieldsByKey[$v->key][$v->lang] = $v;
				else
					$this->cExtraFieldsByKey[$v->key] = $v;
			}
		}

		return $this->cExtraFieldsByKey;
	}

	public function getExtraFieldsValues(): array
	{
		if ($this->cExtraFieldsValues === null) {
			$this->cExtraFieldsValues = [];

			foreach ($this->getExtraFields()->toArray() as $v) {
				if ($v->lang)
					$this->cExtraFieldsValues[$v->key][$v->lang] = $v->value;
				else
					$this->cExtraFieldsValues[$v->key] = $v->value;
			}
		}

		return $this->cExtraFieldsValues;
	}
}
