<?php declare(strict_types = 1);

namespace Core\Model\Helpers\Traits;

use Core\Model\Helpers\Arrays;
use Doctrine\DBAL\Types\Types;
use Doctrine\Migrations\AbstractMigration;

/**
 * @mixin AbstractMigration
 */
trait TMigration
{
	public function migrateSerializedColumnToJson(string $column, string $table, array $keys = ['id' => Types::INTEGER]): void
	{
		$tempColumn = $column . '_json';

		$this->addSql('ALTER TABLE ' . $table . ' ADD ' . $tempColumn . ' JSON DEFAULT NULL');

		$select = $column;
		foreach ($keys as $key => $type) {
			$select .= ', ' . $key;
		}

		foreach ($this->connection->iterateAssociative('SELECT ' . $select . ' FROM ' . $table . ' WHERE ' . $column . ' IS NOT NULL') as $row) {
			$raw = $row[$column];

			if ($raw === 'N;' || $raw === '') {
				$data = null;
			} else {
				try {
					$data = Arrays::serializedToArray($raw);
				} catch (\Exception $e) {
					$this->write(sprintf($e->getMessage(), $row[array_values($keys)[0]]));

					continue;
				}
			}

			$where       = [];
			$whereParams = [
				'json' => $data,
			];
			$typeParams  = [
				'json' => Types::JSON,
			];

			foreach ($keys as $key => $type) {
				$where[]           = $key . ' = :' . $key;
				$whereParams[$key] = $row[$key];
				$typeParams[$key]  = $type;
			}


			$this->addSql('UPDATE ' . $table . ' SET ' . $tempColumn . ' = :json WHERE ' . implode(' AND ', $where), $whereParams, $typeParams);
		}

		$this->addSql('ALTER TABLE ' . $table . ' DROP ' . $column);
		$this->addSql('ALTER TABLE ' . $table . ' CHANGE ' . $tempColumn . ' ' . $column . ' JSON DEFAULT NULL');
	}
}
