<?php declare(strict_types = 1);

namespace Core\Model\Helpers;

class VariableHelper
{
	protected ?array $default = null;

	public function formatValue(string $value): string
	{
		return strtr((string) $value, $this->getDefaults());
	}

	protected function getDefaults(): array
	{
		if ($this->default === null) {
			$this->default = [
				'$year' => date('Y'),
			];
		}

		return $this->default;
	}
}
