<?php declare(strict_types = 1);

namespace Core\Model\Images\Macros;

use Nette\SmartObject;
use Nette;

class Helpers
{
	use SmartObject;

	public static function prepareMacroArguments(string $macro): array
	{
		$arguments = array_map(static fn($value) => trim((string) $value), explode(",", $macro));

		$namespace       = null;
		$name            = $arguments[0];
		$size            = (isset($arguments[1]) and !empty($arguments[1])) ? $arguments[1] : null;
		$flags           = (isset($arguments[2]) and !empty($arguments[2])) ? $arguments[2] : null;
		$watermark       = (isset($arguments[3]) and !empty($arguments[3])) ? $arguments[3] : null;
		$strictMode      = (isset($arguments[4]) and !empty($arguments[4])) ? $arguments[4] : null;
		$outputExtension = (isset($arguments[5]) and !empty($arguments[5])) ? $arguments[5] : null;
		$quality         = (isset($arguments[6]) and !empty($arguments[6])) ? $arguments[6] : null;

		if (count($ns = explode("/", $name)) >= 2) {
			$name      = array_pop($ns);
			$namespace = implode("/", $ns);
		}

		return [
			"namespace"       => $namespace,
			"name"            => $name,
			"size"            => $size,
			"flags"           => $flags,
			"watermark"       => $watermark,
			"strictMode"      => $strictMode,
			"outputExtension" => $outputExtension,
			"quality"         => $quality,
		];
	}

	public static function calculateNewSize(int $originalWidth, int $originalHeight, int $newWidth): array
	{
		if ($originalHeight === 0) {
			$newHeight = 0;
		} else {
			$ratio     = $originalWidth / $originalHeight;
			$newHeight = ceil($newWidth / $ratio);
		}

		return [
			'width'  => $newWidth,
			'height' => $newHeight,
		];
	}

	public static function calculateNewSizeFromString(string $size, int $newWidth, ?int $maxWidth = null): array
	{
		[$width, $height] = array_map('intval', explode('x', $size));

		if ($width && $height) {
			$sizes =  self::calculateNewSize($width, $height, $newWidth);

			if ($maxWidth && $sizes['width'] > $maxWidth) {
				$sizes = self::calculateNewSize($width, $height, $maxWidth);
			}

			return $sizes;
		}

		return [
			'width'  => 0,
			'height' => 0,
		];
	}
}
