<?php declare(strict_types = 1);

namespace Core\Model\Mailing;

use Core\Model\Event\EventDispatcher;
use Core\Model\Event\TemplateFactoryEvent;
use Nette\Mail\Mailer;

class MailBuilderFactory
{
	public ?string $siteIdent = null;

	public function __construct(
		protected Mailer          $mailer,
		protected TemplateFactory $templateFactory,
		protected EventDispatcher $eventDispatcher,
	)
	{
	}

	public function create(?string $siteIdent = null): MailBuilder
	{
		if ($siteIdent) {
			$this->siteIdent = $siteIdent;
		}

		$mail = new MailBuilder($this->mailer);

		if ($this->siteIdent) {
			$mail->setTemplate($this->templateFactory->create($this->siteIdent));
		}

		$this->eventDispatcher->dispatch(new TemplateFactoryEvent($mail->getTemplate()), 'mailBuilderFactory::createTemplate');

		return $mail;
	}
}
