<?php declare(strict_types = 1);

namespace Core\Model\Mailing;

use Core\Model\Event\EventDispatcher;
use Core\Model\Event\TemplateFactoryEvent;
use Core\Model\Settings;
use Core\Model\Sites;
use Core\Model\Templating\Template;
use Core\Model\WebColors;
use Nette\DI\Container;

class TemplateFactory extends AbstractTemplateFactory
{
	public function __construct(
		public Sites              $sites,
		public Settings           $settings,
		public WebColors          $webColors,
		protected Container       $container,
		protected EventDispatcher $eventDispatcher,
	)
	{
		$this->setConfig($this->config);
		$this->setDefaults($this->defaults);
	}

	/**
	 * API *********************************************************************
	 */

	public function create(?string $siteIdent = null, ?string $lang = null): Template
	{
		/** @var \Core\Model\Templating\TemplateFactory $templateFactory */
		$templateFactory = $this->container->getService('latte.templateFactory');

		/** @var Template $template */
		$template = $templateFactory->createTemplate();

		// For macros {link} {plink}
		$template->getLatte()->addProvider('uiControl', $templateFactory->linkGenerator);

		// Prepare template
		$template = $this->prepare($template);

		if ($siteIdent) {
			$site = $this->sites->getSites(false)[$siteIdent];

			if ($lang) {
				$site->currentLang = $lang;
			}

			$template->baseUrl      = 'https://' . $site->getCurrentDomain()->getDomain();
			$template->currentSite  = $site;
			$template->siteName     = $site->getCurrentDomain()->siteName ?: $site->getSiteName();
			$template->siteSettings = $this->settings->getPrefixed($site->getIdent() . '_webSettings');
			$template->webColors    = $this->webColors->getColors($site->getIdent());
		}

		$this->eventDispatcher->dispatch(new TemplateFactoryEvent($template), 'templateFactory::createTemplate');

		return $template;
	}
}
