<?php declare(strict_types = 1);

namespace Core\Model\ORM\Types;

use Doctrine\DBAL\Platforms\AbstractPlatform;
use Doctrine\DBAL\Types\Type;

class ArrayType extends Type
{
	public const NAME = 'array';

	public function getSQLDeclaration(array $fieldDeclaration, AbstractPlatform $platform): string
	{
		return $platform->getClobTypeDeclarationSQL($fieldDeclaration);
	}

	public function convertToDatabaseValue($value, AbstractPlatform $platform): mixed
	{
		if ($value === null) {
			return null;
		}

		return serialize($value);
	}

	public function convertToPHPValue($value, AbstractPlatform $platform): mixed
	{
		if ($value === null || $value === '') {
			return [];
		}
		if (is_array($value)) {
			return $value;
		}
		$unserialized = @unserialize($value);

		return $unserialized === false && $value !== 'b:0;' ? [] : $unserialized;
	}

	public function getName()
	{
		return self::NAME;
	}
}
