<?php declare(strict_types = 1);

namespace Core\Model\Pdf;

use Mpdf\Config\ConfigVariables;
use Mpdf\Config\FontVariables;
use Mpdf\Mpdf;
use Nette\Application\UI\Template;
use Nette\Application\UI\TemplateFactory;

class Pdf
{
	protected array $mPdfConfigDefaults = [
		'tempDir' => TMP_DIR . '/mPdf',
	];

	protected array $mPdfConfig;

	public function __construct(
		?array           $mPdfConfig,
		protected TemplateFactory $templateFactory,
	)
	{
		$mPdfConfig ??= [];
		$this->mPdfConfig = array_merge($this->mPdfConfigDefaults, $mPdfConfig) ?: [];
	}

	/**
	 * @phpstan-ignore-next-line
	 * @return ?Mpdf
	 */
	public function newPdf(array $customConfig = [])
	{
		if (!class_exists('Mpdf\Mpdf')) {
			return null;
		}

		$this->mPdfConfig = $customConfig + $this->mPdfConfig;

		if (class_exists('Mpdf\Config\ConfigVariables') && isset($this->mPdfConfig['fontDir'])) {
			$defaultConfig = (new ConfigVariables())->getDefaults();
			$fontDirs      = $this->mPdfConfig['disableBaseFontDir'] ? [] : $defaultConfig['fontDir'];

			$this->mPdfConfig['fontDir'] = array_merge($fontDirs, $this->mPdfConfig['fontDir']);
		}

		if (class_exists('Mpdf\Config\FontVariables') && isset($this->mPdfConfig['fontData'])) {
			$defaultFontConfig = (new FontVariables())->getDefaults();
			$fontData          = $this->mPdfConfig['disableBaseFontData'] ? [] : $defaultFontConfig['fontdata'];

			$this->mPdfConfig['fontdata'] = $fontData + $this->mPdfConfig['fontData'];
			unset($this->mPdfConfig['fontData']);
		}

		return new Mpdf($this->mPdfConfig);
	}

	public function getTemplateFactory(): Template { return $this->templateFactory->createTemplate(); }
}
