<?php declare(strict_types = 1);

namespace Core\Model\Router;

use Nette\Http\UrlScript;
use Core\Model\Helpers\Strings;
use Closure;
use Nette;
use function str_contains;
use function str_starts_with;

class Route extends Nette\Application\Routers\Route
{
	/**
	 * @param array|string|Closure $metadata
	 */
	public function __construct(string $mask, $metadata = [], ?string $locale = null)
	{
		if ($locale && !Strings::startsWith($mask, '//') && !Strings::startsWith($mask, 'http') && $mask !== '/[<locale [a-z]{2}>]') {
			$mask = '/[<locale=' . $locale . ' [a-z]{2}>/]' . ltrim($mask, '/');
		}

		parent::__construct($mask, $metadata);
	}

	public function constructUrl(array $params, UrlScript $refUrl): ?string
	{
		if (isset($params['presenter']) && str_contains((string) $params['presenter'], 'Override')) {
			$metadata = $this->getMetadata();
			if (isset($metadata['presenter']['value']) && $metadata['presenter']['value'] !== $params['presenter']) {
				$params['presenter'] = str_replace('Override', '', (string) $params['presenter']);
			}
		}

		return parent::constructUrl($params, $refUrl);
	}

}
