<?php declare(strict_types = 1);

namespace Core\Model\Router;

use Core\Model\SystemConfig;
use Users\Model\Security\User;

class RouterFactory
{
	public function __construct(
		protected array       $defaultAdminRoute,
		protected RouteHelper $routeHelper,
		protected User        $user,
	)
	{
	}

	public function createRouter(): RouteList
	{
		$router = new RouteList;

		$router->addRoute('/robots.txt', 'Core:Front:Robots:default', $router::ONE_WAY);
		$router->addRoute('/sitemap-<site>-<group>-<lang>.xml', 'Core:Front:Sitemap:default', $router::ONE_WAY);

		$adminRouteMask = (string) SystemConfig::loadScalar('adminRouteMask') ?: '/admin/<module>/<presenter>[/<action>[/<id>]]';

		$admin = new RouteListAdmin;
		if (SystemConfig::load('checkAdminRoute', true) && $this->user->isAllowed($this->defaultAdminRoute['module'], 'access')) {
			$admin[] = $this->routeHelper->createAdminRoute($adminRouteMask, [
				'module'    => $this->defaultAdminRoute['module'],
				'presenter' => $this->defaultAdminRoute['presenter'],
				'action'    => $this->defaultAdminRoute['action'],
				'id'        => $this->defaultAdminRoute['id'],
			]);
		} else {
			$admin[] = $this->routeHelper->createAdminRoute($adminRouteMask, [
				'module'    => 'Dashboard:Admin',
				'presenter' => 'Default',
				'action'    => 'default',
				'id'        => null,
			]);
		}

		$router[] = $admin;

		$router[] = $cron = new RouteListAdmin;
		$cron[]   = $this->routeHelper->createAdminRoute('/cron/<module>/<presenter>[/<action>[/<id>]]', [
			'module'    => 'Dashboard:Cron',
			'presenter' => 'Default',
			'action'    => 'default'])->setModule('Cron');

		$router[] = $admin = new RouteList('Core:Admin');
		foreach (['filesmanager' => 'FilesManager'] as $url => $presenter) {
			$admin[] = $this->routeHelper->createAdminRoute(
				str_replace('<module>/<presenter>', $url, (string) $adminRouteMask),
				[
					'presenter' => $presenter,
					'action'    => 'default',
					'id'        => null,
				],
			);
		}

		return $router;
	}
}
