<?php declare(strict_types = 1);

namespace Core\Model\TemplateReader\Entity;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\Json;

trait TTemplate
{
	/**
	 * @var string
	 */
	#[ORM\Column(name: 'template', type: 'string', length: 255, nullable: false)]
	public $template;

	#[ORM\Column(name: 'texts', type: Types::JSON, nullable: true)]
	protected ?array $texts = null;

	/**
	 * @return array
	 */
	public function getTexts()
	{
		return is_array($this->texts) ? $this->texts : [];
	}

	/**
	 * @param string $text
	 *
	 * @return string
	 */
	public function getText($text)
	{
		return $this->texts[$text] ?? '';
	}

	/**
	 * @param $texts
	 */
	public function setTexts($texts)
	{
		$this->texts = is_array($texts) ? $texts : Json::decode($texts, forceArrays: true);
	}
}
