<?php declare(strict_types = 1);

namespace Core\Model\TemplateReader\Providers;

use Core\Model\TemplateReader\Entity\ITemplate;
use Core\Model\UI\Form\BaseContainer;

interface ITemplateTextType
{
	public function getType(): string;

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 * @param ITemplate[]   $texts
	 *
	 * @return void
	 */
	public function loadContainer($formContainer, $params = [], $texts = []);

	public function setTitle(string $title): void;

	public function getTitle(): string;

	public function setName(string $name): void;

	public function getName(): string;

	/**
	 * @param mixed|null $default
	 *
	 * @return void
	 */
	public function setDefault($default);

	/**
	 * @return mixed|null
	 */
	public function getDefault();

	/**
	 * @return mixed
	 */
	public function render(array $params);
}
