<?php declare(strict_types = 1);

namespace Core\Model\TemplateReader;

use Core\Model\Helpers\BaseService;
use Core\Model\TemplateReader\Providers\ITemplateTextType;

class TemplateTextTypesCollection extends BaseService
{
	/** @var ITemplateTextType[] */
	protected array $itemsList = [];

	public function getItemByType(string $type): ?ITemplateTextType
	{
		return $this->itemsList[$type] ?? null;
	}

	/**
	 * @return ITemplateTextType[]
	 */
	public function getItems(): array
	{
		return $this->itemsList;
	}

	/**
	 * @param ITemplateTextType[] $items
	 */
	public function setItems(array $items): void
	{
		foreach ($items as $item) {
			$this->itemsList[$item->getType()] = $item;
		}
	}
}
