<?php declare(strict_types = 1);

namespace Core\Model\Templating;

use AllowDynamicProperties;
use Core\Model\Module;
use Core\Model\UI\AbstractPresenter;
use Core\Model\UI\BaseControl;
use Nette\Application\LinkGenerator;
use Nette\Application\UI\Control;
use Nette\Bridges\ApplicationLatte\Template as NTemplate;
use Nette\InvalidStateException;
use Nette\Utils\Arrays;
use Users\Model\Security\User;

/**
 * @method bool isLinkCurrent(string $destination = null, $args = [])
 * @method bool isModuleCurrent(string $module)
 */
#[AllowDynamicProperties]
class Template extends NTemplate
{
	public User   $user;
	public string $baseUrl;
	public string $basePath;
	public string $lang;
	/** @var Control|BaseControl */
	public                   $control;
	public AbstractPresenter $presenter;
	public ?LinkGenerator    $linkGenerator = null;
	public ?Variables        $variables     = null;
	/** @var string[] */
	public array $flashes;

	public function add(string $name, mixed $value): Template
	{
		if (property_exists($this, $name)) {
			throw new InvalidStateException("The variable '$name' already exists.");
		}

		$this->$name = $value;

		return $this;
	}

	public function setParameters(array $params): Template
	{
		return Arrays::toObject($params, $this);
	}

	public function render(?string $file = null, array $params = []): void
	{
		/** @phpstan-ignore-next-line */
		$calledBy = debug_backtrace(!DEBUG_BACKTRACE_PROVIDE_OBJECT | DEBUG_BACKTRACE_IGNORE_ARGS, 2)[1]['class'] ?? null;
		if ($calledBy === 'Core\Model\Http\TextResponse') {
			ob_start();
			parent::render($file, $params);
			$content = ob_get_clean();
			echo $this->replaceVariables((string) $content);
		} else {
			parent::render($file, $params);
		}
	}

	public function renderToString(?string $file = null, array $params = []): string
	{
		$content = parent::renderToString($file, $params);

		return $this->replaceVariables((string) $content);
	}

	protected function replaceVariables(string $content): string
	{
		if (Module::isFront() && $this->variables) {
			return $this->variables->replaceVariables($content);
		}

		return $content;
	}
}
