<?php declare(strict_types = 1);

namespace Core\Model\Turnstile;

use Nette\Utils\Json;

class Response
{
	public bool    $success     = false;
	public array   $errorCodes  = [];
	public ?string $challengeTs = null;
	public ?string $hostname    = null;

	public function hasErrors(): bool
	{
		return !empty($this->errorCodes);
	}

	public function isSuccess(): bool
	{
		return $this->success;
	}

	public static function deserialize(string $jsonResponse): self
	{
		$response             = new self;
		$deserializedResponse = Json::decode($jsonResponse, Json::FORCE_ARRAY);

		if (empty($deserializedResponse)) {
			return $response;
		}

		$response->success     = $deserializedResponse['success'];
		$response->errorCodes  = $deserializedResponse['error-codes'];
		$response->challengeTs = $deserializedResponse['challenge_ts'] ?? null;
		$response->hostname    = $deserializedResponse['hostname'] ?? null;

		return $response;
	}
}
