<?php declare(strict_types = 1);

namespace Core\Model\UI\DataGrid\Column;

use Contributte\Datagrid\Column\ColumnText;
use Contributte\Datagrid\Datagrid;
use Contributte\Datagrid\Row;
use Core\Model\Helpers\Strings;
use Core\Model\SystemConfig;
use Ublaboo;

class ColumnPrice extends ColumnText
{
	protected bool    $currencyFromLeft = false;
	protected ?string $separator        = ' ';
	protected ?string $currency         = 'Kč';
	protected ?string $decSep           = ',';
	protected ?int    $decimals         = 2;

	public function __construct(Datagrid $grid, string $key, string $column, string $name)
	{
		$config                 = SystemConfig::loadArray('priceFilter') ?: [];
		$this->currency         = $config['currency'];
		$this->separator        = $config['separator'];
		$this->currencyFromLeft = $config['currencyFromLeft'];
		$this->decSep           = $config['decSep'];
		$this->decimals         = $config['decimals'];
		parent::__construct($grid, $key, $column, $name);

		$this->setAlign('right');
	}

	public function render(Row $row): mixed
	{
		$value = parent::render($row);

		return $value
			? Strings::priceFormat(
				(float) $value,
				$this->currency,
				$this->separator,
				$this->currencyFromLeft,
				$this->decSep,
				$this->decimals,
			)
			: '';
	}

	public function setCurrencyFromLeft(bool $value = false): self
	{
		$this->currencyFromLeft = $value;

		return $this;
	}

	public function setSeparator(?string $value = null): self
	{
		$this->separator = $value;

		return $this;
	}

	public function setCurrency(?string $value = null): self
	{
		$this->currency = $value;

		return $this;
	}

	public function setDecSep(?string $decSep = null): self
	{
		$this->decSep = $decSep;

		return $this;
	}

	public function setDecimals(?int $decimals = null): self
	{
		$this->decimals = $decimals;

		return $this;
	}
}
