<?php declare(strict_types = 1);

namespace Core\Model\UI\DataGrid\Column;

use Contributte\Datagrid\Datagrid;
use Contributte\Datagrid\Exception\DatagridColumnStatusException;
use Contributte\Datagrid\Row;
use Core\Model\UI\DataGrid\Status\Option;
use Ublaboo;

class ColumnStatus extends \Contributte\Datagrid\Column\ColumnStatus
{
	/** @var null|callable */
	protected $customCurrentOption = null;

	public function __construct(Datagrid $grid, string $key, string $column, string $name)
	{
		parent::__construct($grid, $key, $column, $name);
		$this->setTemplate(__DIR__ . '/../templates/column_status.latte');
	}

	public function addOption(mixed $value, string $text): Option
	{
		if (!is_scalar($value)) {
			throw new DatagridColumnStatusException('Option value has to be scalar');
		}

		$option = new Option($this->grid, $this, $value, $text);

		$this->options[] = $option;

		return $option;
	}

	public function setCustomCurrentOption(callable $callback): self
	{
		$this->customCurrentOption = $callback;

		return $this;
	}

	public function getCurrentOption(Row $row): ?\Contributte\Datagrid\Status\Option
	{
		if ($this->customCurrentOption !== null) {
			return ($this->customCurrentOption)($this, $row);
		}

		foreach ($this->getOptions() as $option) {
			if ($option->getValue() === $row->getValue($this->getColumn())) {
				return $option;
			}
		}

		return null;
	}

}
