<?php declare(strict_types = 1);

namespace Core\Model\UI\DataGrid\DataSource;

use Core\Model\Entities\QueryBuilder;
use Contributte\Datagrid\DataSource\IDataSource;
use Contributte\Datagrid\Utils\Sorting;

class DoctrineDataSource extends \Contributte\Datagrid\DataSource\DoctrineDataSource
{
	public array $lastSort = [];

	/**
	 * @return \Doctrine\ORM\QueryBuilder|QueryBuilder
	 */
	public function getQueryBuilder(): \Doctrine\ORM\QueryBuilder|QueryBuilder
	{
		return $this->dataSource;
	}

	/**
	 * @return $this
	 */
	public function setQueryBuilder(QueryBuilder $qb): self
	{
		$this->dataSource = $qb;

		return $this;
	}

	/**
	 * @return $this
	 */
	public function updateQueryBuilder(callable $call): self
	{
		$call($this->dataSource);

		return $this;
	}

	public function sort(Sorting $sorting): IDataSource
	{
		parent::sort($sorting);

		foreach ($this->lastSort as $column => $dir)
			$this->dataSource->addOrderBy($column, $dir);

		return $this;
	}

}
