<?php declare(strict_types = 1);

namespace Core\Model\UI\DataGrid\Filter;

use Contributte\Datagrid\Datagrid;
use Contributte\Datagrid\Filter\Filter;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\Controls\RadioNestedInput;
use Nette\Forms\Controls\BaseControl;

class FilterRadioNestedList extends Filter
{
	protected ?string $template = 'datagrid_filter_radio_nested_list.latte';

	protected ?string $type = 'radioNestedList';

	public function __construct(Datagrid $grid, string $key, string $name, protected array $flatItems)
	{
		parent::__construct($grid, $key, $name);
	}

	public function getCondition(): array
	{
		return [];
	}

	public function addToFormContainer(BaseContainer $container): void
	{
		$control = $container->addRadioNestedList($this->key, $this->name, $this->flatItems);
		$control->setViewType(RadioNestedInput::VIEW_TYPE_COMPACT);

		$this->addAttributes($control);
	}

	protected function addAttributes(BaseControl $input): BaseControl
	{
		if ($this->grid->hasAutoSubmit()) {
			$input->setHtmlAttribute('data-autosubmit', true);
		} else {
			$input->setHtmlAttribute('data-datagrid-manualsubmit', true);
		}

		foreach ($this->attributes as $key => $value) {
			if (is_array($value)) {
				$value = array_unique($value);
				$value = implode(' ', $value);
			}

			$input->setHtmlAttribute($key, $value);
		}

		return $input;
	}

}
