<?php declare(strict_types = 1);

namespace Core\Model\UI\DataGrid\Status;

use Core\Model\UI\DataGrid\Column\ColumnStatus;
use Ublaboo;

class Option extends \Contributte\Datagrid\Status\Option
{
	protected bool   $showTitle = true;
	protected string $style     = '';

	protected ColumnStatus|\Contributte\Datagrid\Column\ColumnStatus $columnStatus;

	public function endOption(): ColumnStatus|\Contributte\Datagrid\Column\ColumnStatus
	{
		return $this->columnStatus;
	}

	public function addStyle(string $style): self
	{
		$this->style .= ' ' . $style;

		return $this;
	}

	public function getStyle(): string
	{
		return trim($this->style);
	}

	public function setShowTitle(bool $show = true): self
	{
		$this->showTitle = $show;

		return $this;
	}

	public function getShowTitle(): bool { return $this->showTitle; }
}
