<?php declare(strict_types = 1);

namespace Core\Model\UI\DataGrid\Traits;

use Nette\Utils\Html;
use Contributte\Datagrid\Datagrid;

trait TButtonTryAddIcon
{

	public function tryAddIcon(Html $el, ?string $iconString, string $name): void
	{
		if ($iconString !== null) {
			$iconClass = '';

			if (str_starts_with($iconString, 'fas')) {
				$iconClass = $iconString;
			} else {
				foreach (explode(' ', $iconString) as $icon) {
					$iconClass .= ' ' . Datagrid::$iconPrefix . $icon;
				}
			}

			$el->addHtml(Html::el('span')->setAttribute('class', trim($iconClass)));
		}
	}
}
