<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Nette\Utils\Html;

class ColorInput extends TextInput
{
	public function __construct($label = null, int $maxLength = null)
	{
		parent::__construct($label, $maxLength);
		$this->setNullable(true);
		$this->setDefaultValue(null);
	}

	public function getControl(): Html
	{
		$control = parent::getControl();

		$wrap = Html::el('div', [
			'class'                        => 'frm__color-input',
			'data-color-input'             => 'wrap',
			'data-color-picker-text-save'  => $this->translate('default.choose'),
			'data-color-picker-text-clear' => $this->translate('default.clear'),
		]);

		$btn = Html::el('div', [
			'class'            => 'frm__color-input--btn',
			'data-color-input' => 'btn',
		]);

		$control->addAttributes([
			'data-color-input' => 'input',
		]);

		$wrap->addHtml($btn)
			->addHtml($control);

		return $wrap;
	}

}
