<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Nextras\FormComponents\Controls\DateControl;
use Core\Model\UI\Form\BaseForm;
use Core\Model\UI\Form\Traits\TInputExtend;
use Nette\Utils\Html;
use Nextras;

/**
 * @method BaseForm getForm(bool $throw = true)
 */
class DatePicker extends DateControl
{
	use TInputExtend;

	/** @var string */
	protected $htmlFormat = 'd. m. Y';

	/** @var string */
	protected $htmlType = 'text';

	public function getControl(): Html
	{
		$wrapper = Html::el('div');
		$control = parent::getControl();

		$control->attrs['class'][] = 'datepicker form-control form-control-lg';
		$wrapper->addHtml($control);

		return $wrapper;
	}

}
