<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Nette\HtmlStringable;
use Core\Model\UI\AbstractPresenter;
use Nette;
use Nette\DI\Container;
use Nette\Utils\Html;

class GalleryPopupInput extends HiddenInput
{
	protected array $values = [];

	public function __construct(
		string $label,
	)
	{
		parent::__construct();
		$this->setCaption($label);
	}

	public function getControl(): Html
	{
		/** @var AbstractPresenter $presenter */
		$presenter = $this->lookup(AbstractPresenter::class, false);

		$control = Html::el();
		if ($this->getValue()) {
			$link = $presenter->link(':Gallery:Admin:Album:popup', [
				'id'     => (int) $this->getValue(),
				'htmlId' => $this->getHtmlId(),
			]);
		} else {
			$link = $presenter->link(':Gallery:Admin:Album:popup', [
				'htmlId' => $this->getHtmlId(),
			]);
		}

		$button = Html::el('a class="btn btn-info ajax"', ['href' => $link])
			->setAttribute('id', $this->getHtmlId() . 'GalleryLink')
			->setText($this->translate('gallery.galleryPopupInput.editGallery'));

		$caption = $this->getCaption();

		$labelEl = Html::el('label');
		if (is_string($caption) || $caption instanceof HtmlStringable) {
			$labelEl->addHtml($caption);
		}

		$control->addHtml($labelEl);
		$control->addHtml('<br>');
		$control->addHtml($button);
		$control->addHtml(parent::getControl());

		return $control;
	}

	/*******************************************************************************************************************
	 * ======================== REGISTER
	 */

	public static function register(Container $systemContainer): void
	{
		$class = self::class;
		Nette\Forms\Container::extensionMethod('addGalleryPopup', static function(
			Nette\Forms\Container $container,
			                      $name,
			                      $caption,
		) use ($class): GalleryPopupInput {
			$comp = new $class($caption);

			$container->addComponent($comp, $name);

			return $comp;
		});
	}
}
