<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Core\Model\Lang\ILang;
use Core\Model\Lang\Langs;
use Nette\Forms\Container;

class LangsSelectInput extends SelectInput
{
	protected bool $allowAllLang = true;

	public function __construct($label, protected Langs $langsService)
	{
		$items = ['' => 'default.all'];

		foreach ($langsService->getLangs() as $lang) {
			if ($lang instanceof ILang) {
				$items[$lang->getTag()] = $lang->getTitle();
			}
		}

		parent::__construct($label, $items);

		$this->setDefaultValue($langsService->getLang()->getTag());
	}

	public function allowAllLang(bool $allow = true): self
	{
		$this->allowAllLang = $allow;

		return $this;
	}

	public function setItems(array $items, bool $useKeys = true): self
	{
		if ($items) {
			parent::setItems($items, $useKeys);
		} else {
			$items = $this->allowAllLang ? ['' => 'default.all'] : [];
			$langs = $this->langsService;

			foreach ($langs->getLangs() as $lang) {
				if ($lang instanceof ILang) {
					$items[$lang->getTag()] = $lang->getTitle();
				}
			}

			parent::setItems($items);
			$this->setDefaultValue($langs->getLang()->getTag());
		}

		return $this;
	}

	/*******************************************************************************************************************
	 * ======================== REGISTER
	 */

	public static function register(\Nette\DI\Container $systemContainer): void
	{
		$class = self::class;
		Container::extensionMethod('addLangsSelect', static function(
			Container $container,
			                       $name,
			                       $caption,
		) use ($class, $systemContainer) {
			/** @var LangsSelectInput $comp */
			$comp = new $class($caption, $systemContainer->getService('langs'));

			$container->addComponent($comp, $name);

			return $comp;
		});
	}
}
