<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Core\Model\UI\Form\BaseForm;
use Core\Model\UI\Form\Traits\TInputExtend;
use Core\Model\UI\Form\Traits\TTextBase;

/**
 * @method BaseForm getForm(bool $throw = true)
 */
class TextInput extends \Nette\Forms\Controls\TextInput
{
	use TInputExtend;
	use TTextBase;

	/** @var string|array|null */
	protected $placeholder = null;

	/*
	 * @inheritdoc
	 */
	public function __construct($label = null, int $maxLength = null)
	{
		parent::__construct($label, $maxLength);
		$this->setRequired(false);
	}

	/**
	 * @return string|array|null
	 */
	public function getPlaceholder() { return $this->placeholder; }

	/**
	 * @param string|array $placeholder
	 */
	public function setPlaceholder($placeholder): self
	{
		if (is_array($placeholder)) {
			foreach ($placeholder as $k => $v) {
				$this->placeholder[$k] = $this->translate($v);
			}
		} else {
			$this->placeholder = $this->translate($placeholder);
		}

		return $this;
	}
}
