<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Nette\Utils\Html;
use Nextras\FormComponents\Controls\DateTimeControl;

class TimePicker extends DateTimeControl
{
	/** @var string */
	protected $htmlFormat = 'H:i';

	/** @var string */
	protected $htmlType = 'text';

	public function getControl(): Html
	{
		$wrapper = Html::el('div');
		$control = parent::getControl();

		$control->attrs['class'][] = 'timepicker form-control form-control-lg';
		$wrapper->addHtml($control);

		return $wrapper;
	}
}
