<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Traits;

use Contributte\ReCaptcha\Forms\InvisibleReCaptchaField;
use Contributte\ReCaptcha\Forms\ReCaptchaField;
use Core\Model\UI\Form\Controls;
use Core\Model\UI\Form\Controls\BoolInput;
use Core\Model\UI\Form\Controls\CheckboxListNestedInput;
use Core\Model\UI\Form\Controls\ColorInput;
use Core\Model\UI\Form\Controls\DatePicker;
use Core\Model\UI\Form\Controls\DateTimePicker;
use Core\Model\UI\Form\Controls\RadioNestedInput;
use Core\Model\UI\Form\Controls\SaveCancelControl;
use Core\Model\UI\Form\Controls\SortableCheckboxList;
use Core\Model\UI\Form\Controls\TagsInput;
use Core\Model\UI\Form\Controls\TimePicker;
use Core\Model\UI\Form\Controls\Window;

/**
 * @method Controls\FilesManagerInput addFilesManager($name, $caption)
 * @method Controls\EditorInput addEditor($name, $caption)
 * @method Controls\LangsSelectInput addLangsSelect($name, $caption)
 * @method Controls\GalleryPopupInput addGalleryPopup($name, $caption)
 * @method InvisibleReCaptchaField addInvisibleReCaptcha(string $name = 'recaptcha', bool $required = true, ?string $message = null)
 * @method ReCaptchaField addReCaptcha(string $name = 'recaptcha', string $label = 'ReCaptcha', bool $required = true, ?string $message = null)
 */
trait BaseContainerTrait
{
	public function addBool(string $name, $label = null, array $items = []): BoolInput
	{
		$comp = new BoolInput($label, $items);
		$this->addComponent($comp, $name);

		return $comp;
	}

	public function addDateTimePicker(string $name, $label = null): DateTimePicker
	{
		$comp = new DateTimePicker($label);
		$this->addComponent($comp, $name);

		return $comp;
	}

	public function addDatePicker(string $name, $label = null): DatePicker
	{
		$comp = new DatePicker($label);
		$this->addComponent($comp, $name);

		return $comp;
	}

	public function addTimePicker(string $name, $label = null): TimePicker
	{
		$comp = new TimePicker($label);
		$this->addComponent($comp, $name);

		return $comp;
	}

	public function addTags(
		string    $name,
		?string   $label = null,
		?callable $callback = null,
		?callable $createCallback = null,
	): TagsInput
	{
		$comp = new TagsInput($label, $callback, $createCallback);
		$this->addComponent($comp, $name);

		return $comp;
	}

	public function addSortableCheckboxList(
		string  $name,
		?string $label = null,
		array   $items = [],
	): SortableCheckboxList
	{
		$comp = new SortableCheckboxList($label, $items);
		$this->addComponent($comp, $name);

		return $comp;
	}

	public function addRadioNestedList(
		string  $name,
		?string $label = null,
		array   $flatItems = [],
	): RadioNestedInput
	{
		$comp = new RadioNestedInput($label, $flatItems);
		$this->addComponent($comp, $name);

		return $comp;
	}

	public function addCheckboxNestedList(
		string  $name,
		?string $label = null,
		array   $flatItems = [],
	): CheckboxListNestedInput
	{
		$comp = new CheckboxListNestedInput($label, $flatItems);
		$this->addComponent($comp, $name);

		return $comp;
	}

	/**
	 * @param string $name
	 *
	 * @return Controls\SaveCancelControl
	 */
	public function addSaveCancelControl(
		$name = 'saveControl',
		?string $saveCaption = null,
		?string $saveAndCloseCaption = null,
		?string $cancelCaption = null,
	)
	{
		$comp = new SaveCancelControl($saveCaption, $saveAndCloseCaption, $cancelCaption);
		$this->addComponent($comp, $name);

		return $comp;
	}

	public function addColorInput(string $name, ?string $label = null): ColorInput
	{
		$comp = new ColorInput($label, 255);
		$this->addComponent($comp, $name);

		return $comp;
	}

	public function addWindow(string $name, string $url, ?string $label = null): Window
	{
		$comp = new Window($url, $label);
		$this->addComponent($comp, $name);

		return $comp;
	}
}
