<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Traits;

use Nette\InvalidArgumentException;
use Nette\NotSupportedException;
use Stringable;

trait InputPromptTrait
{
	/**
	 * @var string|null|Stringable
	 */
	protected $prompt = null;

	public function getPrompt(): Stringable|string|false
	{
		return $this->prompt;
	}

	public function setPrompt(Stringable|string|false $prompt): static
	{
		if (empty($prompt)) {
			return $this;
		}

		/** @phpstan-ignore-next-line */
		if (isset($this->items)) {
			if (in_array(null, array_keys($this->items))) {
				throw new InvalidArgumentException(
					"There is an item whose value == null (non-strict comparison)." .
					"Setting prompt would interfere with this value."
				);
			}
		} else {
			throw new NotSupportedException('This must be a ChoiceControl');
		}

		$this->prompt = $prompt;

		return $this;
	}
}
