<?php declare(strict_types = 1);

namespace Core\Model;

use Core\Model\Helpers\Strings;

class WebColors
{
	protected static array $cColors = [];

	public function __construct(
		protected Settings $settings,
	)
	{
	}

	public function clearCache(): void
	{
		$this->settings->clearCache();
		self::$cColors = [];
	}

	public function getColors(string $siteIdent = ''): array
	{
		$siteIdent = $siteIdent === '' ? $siteIdent : $siteIdent . '_';

		if (!isset(self::$cColors[$siteIdent])) {
			$baseLayout = $this->settings->get($siteIdent . 'baseLayout', '', false);

			if ($baseLayout) {
				self::$cColors[$siteIdent] = $this->settings->getPrefixed($siteIdent . 'webColors' . Strings::firstUpper($baseLayout)) ?: [];
			} else {
				self::$cColors[$siteIdent] = $this->settings->getPrefixed($siteIdent . 'webColors') ?: [];
			}
		}

		return self::$cColors[$siteIdent];
	}
}
