import flatpickr from "flatpickr";
import {Czech} from "flatpickr/dist/l10n/cs.js";
import monthSelectPlugin from "flatpickr/dist/plugins/monthSelect/index";
import Choices from "choices.js";

const showTtLinkTypeFrmPair = (selectEl) => {
	let fieldset = selectEl.closest('fieldset');

	fieldset.querySelectorAll('[name*="component[' + selectEl.dataset.ttLinkSelect + '][types]"]').forEach(inputEl => {
		let wrap = inputEl.closest('.frm__pair');

		if (inputEl.name.indexOf('component[' + selectEl.dataset.ttLinkSelect + '][types][' + selectEl.value + ']') === 0) {
			wrap.style.display = 'block';
		} else {
			wrap.style.display = 'none';
		}
	})
}

const initShowTtLinkTypeFrmPair = () => {
	document.querySelectorAll('[data-tt-link-select]').forEach(selectEl => {
		showTtLinkTypeFrmPair(selectEl);
	})
}

document.addEventListener('DOMContentLoaded', () => {
	initShowTtLinkTypeFrmPair();
});

document.addEventListener('change', e => {
	const target = e.target;

	if (target.dataset.ttLinkSelect !== undefined) {
		showTtLinkTypeFrmPair(target);
	}
})

const choicesAddCallback = (choicesElement) => {
	choicesElement.input.element.addEventListener('keydown', (keypressEvent) => {
		if (keypressEvent.keyCode === 13 && keypressEvent.target.value) {
			let keywordHits = 0;
			[...choicesElement.choiceList.element.children].forEach((element) => {
				if (element.innerText.includes(keypressEvent.target.value)) {
					keywordHits += 1;
				}
			});
			if (!keywordHits) {
				keypressEvent.stopPropagation();
				const linterEvent = keypressEvent;
				global.naja.makeRequest('post', choicesElement.passedElement.element.dataset.addCallback, {
					'value': linterEvent.target.value
				}, {history: false}).then(response => {
					if (response.status === 'ok' && response.data) {
						choicesElement.setChoices([
							{
								value   : response.data.id,
								label   : response.data.name,
								selected: true,
							},
						], 'value', 'label', false);
					}

					linterEvent.target.value = '';
				});
			}
		}
	});
};

const initDatePickers = () => {
	document.querySelectorAll('.datetimepicker, .datepicker, [data-provide="datepicker"]').forEach(el => {
		const parentElement = el.parentElement;

		if (!el.closest('.flatpicker-wrap')) {
			let clearA = document.createElement('a');
			clearA.setAttribute('class', 'btn btn-xs btn-danger');
			clearA.setAttribute('href', 'javascript:;');
			clearA.setAttribute('data-clear', '');
			clearA.innerHTML = '<i class="fas fa-times"></i>';

			try {
				parentElement.classList.add('flatpicker-wrap');
				parentElement.insertBefore(clearA, parentElement.nextElementSibling);
				el.parentElement.appendChild(clearA);
			} catch (e) {
			}
		}

		el.addEventListener('click', e => {
			if (el.inited === true) {
				return;
			}

			let isDate     = el.classList.contains('datepicker') || el.type === 'date';
			let dateFormat = 'd. m. Y';
			let enableDate = !isDate;

			if (!isDate) {
				dateFormat = 'd. m. Y - H:i';
				enableDate = true;
			}

			if (el.dataset.provide === 'datepicker') {
				dateFormat = 'd. m. Y';
				enableDate = false;
			}

			let options = {
				locale     : Czech,
				minDate    : el.dataset.min,
				maxDate    : el.dataset.max,
				time_24hr  : true,
				dateFormat : dateFormat,
				enableTime : enableDate,
				defaultDate: el.getAttribute('value'),
			}

			if (el.dataset.monthSelect === 'true') {
				options.plugins = [
					new monthSelectPlugin({
						shorthand : false,
						dateFormat: "Y-m",
						altFormat : "T-m",
						theme     : "blue"
					})
				];
			}

			flatpickr(el, options);

			if (el.inited !== true) {
				el.inited = true;

				el._flatpickr.open();
			}

			el.inited = true;
		});

		let wrap = el.closest('.flatpicker-wrap');
		if (wrap) {
			let clearEl = wrap.querySelector('a');

			if (clearEl) {
				clearEl.addEventListener('click', e => {
					if (el.inited === true)
						el._flatpickr.clear();
					else
						el.value = '';
				});
			}
		}
	})
}
const initTimePickers = () => {
	document.querySelectorAll('.timepicker').forEach(el => {
		el.addEventListener('click', e => {
			if (el.inited === true)
				return;

			let options = {
				locale     : Czech,
				minTime    : el.dataset.min,
				maxTime    : el.dataset.max,
				time_24hr  : true,
				dateFormat : 'H:i',
				enableTime : true,
				noCalendar : true,
				defaultDate: el.getAttribute('value'),
			}

			flatpickr(el, options);

			if (el.inited !== true) {
				el.inited = true;

				el._flatpickr.open();
			}

			el.inited = true;
		});

		let wrap = el.closest('.flatpicker-wrap');
		if (wrap) {
			let clearEl = wrap.querySelector('a');

			clearEl.addEventListener('click', e => {
				el._flatpickr.clear();
			});
		}
	})
}

const initSelectOne = () => {
	document.querySelectorAll('.nested-list').forEach(group => {
		let items = group.querySelectorAll('.nested-list__item');
		items.forEach(el => {
			let span = el.querySelector('.select-one');

			if (span) {
				span.addEventListener('click', e => {
					e.stopImmediatePropagation();

					group.querySelectorAll('.nested-list__item input:checked').forEach(input => {
						input.removeAttribute('checked');
						input.checked = false;
					});

					let input = span.nextElementSibling;

					input.checked = true;
					input.dispatchEvent(new Event('change'));

					return false;
				})
			}
		});
	});
}

let choicesIndex   = 0;
global.choicesList = global.choicesList || {};
const initChoices  = () => {
	document.querySelectorAll(
		'.frm__type-select select:not([data-choice]), ' +
		'select.select--choice:not([data-choice]), ' +
		'.col-filters select:not([data-choice])'
	).forEach(select => {
		if (select.style.display === 'none')
			return true;

		let threshold = select.dataset.threshold || .3;

		let config = {
			loadingText      : '',
			noResultsText    : '',
			noChoicesText    : '',
			itemSelectText   : '',
			shouldSort       : false,
			shouldSortItems  : false,
			searchResultLimit: 15,
			fuseOptions      : {
				isCaseSensitive   : false,
				threshold         : threshold,
				distance          : 200,
				ignoreLocation    : true,
				includeScore      : true,
				minMatchCharLength: 2,
			},
		};

		if (select.dataset.addCallback !== undefined) {
			config.fuseOptions.threshold = 0;
		}

		global.choicesList[choicesIndex] = new Choices(select, config);

		if (select.dataset.addCallback !== undefined) {
			choicesAddCallback(global.choicesList[choicesIndex]);
		}

		select.setAttribute('data-choices-index', choicesIndex);
		let choices = global.choicesList[choicesIndex];

		if (select.getAttribute('data-confirm')) {
			choices._handleChoiceAction = (activeItems, element) => {
				if (!activeItems || !element) {
					return;
				}

				const {id}   = element.dataset;
				const choice = choices._store.getChoiceById(id);
				if (!choice) {
					return;
				}

				if (choices.getValue().value) {
					let r = confirm(select.getAttribute('data-confirm'));
					if (r !== true) {
						return
					}
				}

				const passedKeyCode     =
					      activeItems[0] && activeItems[0].keyCode ? activeItems[0].keyCode : null;
				const hasActiveDropdown = choices.dropdown.isActive;

				choice.keyCode = passedKeyCode;

				choices.passedElement.triggerEvent('choice', {
					choice,
				});

				if (!choice.selected && !choice.disabled) {
					const canAddItem = choices._canAddItem(activeItems, choice.value);

					if (canAddItem.response) {
						choices._addItem({
							value           : choice.value,
							label           : choice.label,
							choiceId        : choice.id,
							groupId         : choice.groupId,
							customProperties: choice.customProperties,
							placeholder     : choice.placeholder,
							keyCode         : choice.keyCode,
						});

						choices._triggerChange(choice.value);
					}
				}

				choices.clearInput();

				if (hasActiveDropdown && choices._isSelectOneElement) {
					choices.hideDropdown(true);
					choices.containerOuter.focus();
				}
			}
		}

		choicesIndex++;
	});
}

initDatePickers();
initTimePickers();
initSelectOne();
initChoices();

// Kvůli kompatibilitě s jquery
window.jQuery(document).ajaxComplete(function (event, xhr, settings) {
	initDatePickers();
	initTimePickers();
	initSelectOne();
	initChoices();
	initShowTtLinkTypeFrmPair();
});

global.naja.addEventListener('complete', e => {
	initDatePickers();
	initTimePickers();
	initSelectOne();
	initChoices();
	initShowTtLinkTypeFrmPair();
});

document.addEventListener('formInputsInit', e => {
	initChoices();
})

document.addEventListener('contentLangChange', e => {
	document.querySelectorAll('select[data-choice][data-content-lang]').forEach(el => {
		if (el.dataset.contentLang !== e.detail.lang)
			el.closest('.choices').style.display = 'none';
		else
			el.closest('.choices').style.display = 'block';
	})

	initChoices();
})

document.addEventListener('click', e => {
	if (e.target.dataset.translateTo) {
		const targetLang = e.target.dataset.translateTo;

		if (targetLang.length === 2) {
			const labelWrap   = e.target.closest('.label-wrap');
			const pairWrap    = e.target.closest('.frm__pair');
			const input       = pairWrap.querySelector('[name="' + labelWrap.dataset.name + '[' + window.defaultLang + ']"]');
			const targetInput = pairWrap.querySelector('[name="' + labelWrap.dataset.name + '[' + targetLang + ']"]');

			if (input && targetInput) {
				const isEditorWrap   = targetInput.closest('.frm__type-editor');
				let textForTranslate = input.value;

				if (isEditorWrap) {
					const inputEditorTextarea = isEditorWrap.querySelector('.ck_textarea[data-content-lang="' + window.defaultLang + '"]');

					if (inputEditorTextarea) {
						textForTranslate = CKEDITOR.instances[inputEditorTextarea.id].getData();
					}
				}

				global.naja.makeRequest('post', window.translatorLinkDeepL, {
					'key'       : targetInput.id,
					'text'      : textForTranslate,
					'sourceLang': window.defaultLang,
					'targetLang': targetLang,
				}, {history: false}).then(response => {
					if (response.result) {
						if (isEditorWrap) {
							const targetEditorTextarea = isEditorWrap.querySelector('.ck_textarea[data-content-lang="' + targetInput.dataset.contentLang + '"]');

							if (targetEditorTextarea) {
								if (CKEDITOR !== undefined && CKEDITOR.instances[targetEditorTextarea.id] !== undefined) {
									CKEDITOR.instances[targetEditorTextarea.id].setData(response.result);
								} else {
									targetEditorTextarea.innerHTML = response.result;

									if (targetEditorTextarea.dataset.inputId) {
										const targetInput = document.getElementById(targetEditorTextarea.dataset.inputId);

										if (targetInput) {
											targetInput.value = response.result;
										}
									}
								}
							}
						} else {
							targetInput.value = response.result;
						}

						e.target.classList.add('btn-success');
					}
				});

				e.preventDefault();
				return false;
			}
		}
	} else if (e.target.dataset.translateLocked) {
		const targetLang = e.target.dataset.lang;

		if (targetLang.length === 2) {
			const labelWrap        = e.target.closest('.label-wrap');
			const pairWrap         = e.target.closest('.frm__pair');
			const targetInput      = pairWrap.querySelector('[name="' + labelWrap.dataset.name + '[' + targetLang + ']"]');
			const currentLockValue = parseInt(e.target.dataset.translateLocked);

			if (targetInput.id) {
				global.naja.makeRequest('post', window.translatorLinkLock, {
					'key'   : targetInput.id,
					'locale': targetLang,
					'value' : !currentLockValue,
				}, {history: false}).then(response => {
					if (response.result) {
						e.target.classList.remove('btn-default');
						e.target.classList.remove('fa-lock-open');
						e.target.classList.add('btn-danger');
						e.target.classList.add('fa-lock');
						e.target.dataset.translateLocked = 1;
					} else {
						e.target.classList.remove('btn-danger');
						e.target.classList.remove('fa-lock');
						e.target.classList.add('btn-default');
						e.target.classList.add('fa-lock-open');
						e.target.dataset.translateLocked = 0;
					}
				});
			}

			e.preventDefault();
			return false;
		}
	} else if (e.target.dataset.translateMissing) {
		const targetLang = e.target.dataset.translateMissing;
		const form       = e.target.closest('form');

		if (form && targetLang) {
			const missingInputs = getDataFormTranslate(targetLang === 'all' ? null : targetLang, form, true);

			global.naja.makeRequest('post', window.translatorLinkDeepLMulti, {
				'sourceLang': window.defaultLang,
				'data'      : JSON.stringify(missingInputs),
			}, {history: false}).then(response => {
				if (response.result) {
					processTranslatedData(response.result);
				}
			});

			e.preventDefault();
			return false;
		}
	} else if (e.target.dataset.translateAll) {
		const targetLang = e.target.dataset.translateAll;
		const form       = e.target.closest('form');

		if (form && targetLang) {
			const missingInputs = getDataFormTranslate(targetLang === 'all' ? null : targetLang, form, false);

			global.naja.makeRequest('post', window.translatorLinkDeepLMulti, {
				'sourceLang': window.defaultLang,
				'data'      : JSON.stringify(missingInputs),
			}, {history: false}).then(response => {
				if (response.result) {
					processTranslatedData(response.result);
				}
			});

			e.preventDefault();
			return false;
		}
	} else if (e.target.dataset.copyImageFile !== undefined) {
		const copyType = e.target.dataset.copyImageFile;
		let currentLang = document.querySelector('[name="selectedContentLang"]:checked').value;
		const wrap = e.target.closest('fieldset.tt-image');

		const btnInner = e.target.innerHTML;
		e.target.style.width = e.target.getBoundingClientRect().width + 'px';
		e.target.style.height = e.target.getBoundingClientRect().height + 'px';

		let result = false;
		try {
			const value = wrap.querySelector('.filemanager-control[data-content-lang="' + currentLang + '"] .filesManagerInput-fakeInput').value;

			let path = null;
			wrap.querySelectorAll('.filemanager-control').forEach(filesManager => {
				if (filesManager.dataset.contentLang !== currentLang) {
					const fakeInput = filesManager.querySelector('.filesManagerInput-fakeInput');
					const input     = filesManager.querySelector('input[type="hidden"]');

					if (!fakeInput || !input) {
						throw 'err';
					}

					if (copyType === 'empty' && input.value.length > 0) {
						return true;
					}

					if (fakeInput) {
						fakeInput.value = value;
					}

					if (input) {
						input.value = value;
					}
				}
			})

			result = true;
		} catch (e) {
		}

		e.target.classList.remove('btn-default');
		if (result) {
			e.target.classList.add('btn-success');
			e.target.innerHTML = '<i class="fa fa-check"></i>';
		} else {
			e.target.classList.add('btn-danger');
			e.target.innerHTML = '<i class="fa fa-times"></i>';
		}

		setTimeout(() => {
			e.target.classList.remove('btn-success');
			e.target.classList.remove('btn-danger');
			e.target.classList.add('btn-default');
			e.target.innerHTML = btnInner;
		}, 3000);
	}
});

const getDataFormTranslate = (lang, form, onlyEmpty) => {
	const missingInputs = {};

	form.querySelectorAll(lang ? '[data-content-lang="' + lang + '"]' : '[data-content-lang]').forEach(input => {
		if (!onlyEmpty || input.value === '') {
			const targetLang = input.dataset.contentLang;

			if (targetLang === window.defaultLang) {
				return true;
			}

			const pairWrap    = input.closest('.frm__pair');
			const labelWrap   = pairWrap.querySelector('.label-wrap');
			const sourceInput = pairWrap.querySelector('[name="' + labelWrap.dataset.name + '[' + window.defaultLang + ']"]');

			const isLockedInput = pairWrap.querySelector('[data-lang="' + targetLang + '"][data-translate-locked]');
			if (!isLockedInput) {
				return true;
			}

			const isLocked = isLockedInput.dataset.translateLocked === '1';
			if (isLocked) {
				return true;
			}

			if (missingInputs[targetLang] === undefined) {
				missingInputs[targetLang] = [];
			}

			if (sourceInput) {
				const isEditorWrap   = sourceInput.closest('.frm__type-editor');
				let textForTranslate = sourceInput.value;

				if (isEditorWrap) {
					const inputEditorTextarea = isEditorWrap.querySelector('.ck_textarea[data-content-lang="' + window.defaultLang + '"]');

					if (inputEditorTextarea) {
						textForTranslate = CKEDITOR.instances[inputEditorTextarea.id].getData();
					}
				}

				missingInputs[targetLang].push({
					'key'  : input.id,
					'value': textForTranslate,
				});
			}
		}
	});

	return missingInputs;
}

const processTranslatedData = (data) => {
	Object.keys(data).forEach(lang => {
		data[lang].forEach(item => {
			try {
				const targetInput = document.getElementById(item.key);

				if (!targetInput) {
					return true;
				}

				const isEditorWrap = targetInput.closest('.frm__type-editor');
				if (isEditorWrap) {
					const targetEditorTextarea = isEditorWrap.querySelector('.ck_textarea[data-content-lang="' + lang + '"]');

					if (targetEditorTextarea) {
						if (CKEDITOR !== undefined && CKEDITOR.instances[targetEditorTextarea.id] !== undefined) {
							CKEDITOR.instances[targetEditorTextarea.id].setData(item.result);
						} else {
							targetEditorTextarea.innerHTML = item.result;

							if (targetEditorTextarea.dataset.inputId) {
								const targetInput = document.getElementById(targetEditorTextarea.dataset.inputId);

								if (targetInput) {
									targetInput.value = item.result;
								}
							}
						}
					}
				} else {
					targetInput.value = item.result;
				}

				const pairWrap     = targetInput.closest('.frm__pair');
				const translateBtn = pairWrap.querySelector('[data-translate-to="' + lang + '"]');

				translateBtn.classList.add('btn-success');
			} catch (e) {
				console.error(e);
			}
		});
	});
}
