import SimpleBar from 'simplebar';
import Cookies from "js-cookie";
import naja from "naja";
import {checkMedia, Utilities} from "core/front/src/js/utils/utilities";
import Pickr from "@simonwep/pickr";
import "tablesaw/dist/tablesaw.jquery";
import {Autocomplete} from './utils/AutoComplete';

naja.historyHandler.uiCache = false;
naja.history                = false;
naja.uiHandler.selector     = '';

window.naja                           = naja;
global.naja                           = window.naja;
global.clickActiveElement             = null;
global.datagridPaginatorActiveElement = null;

/**
 * Interakce / responzivita
 */
if (document.readyState === "complete") {
	new Autocomplete();
}

document.addEventListener('click', e => {
	global.clickActiveElement             = document.activeElement;
	global.datagridPaginatorActiveElement = document.activeElement;
});

const menuMinimalize = document.querySelector('.navbar__menu-minimalize');
const hamburger      = document.querySelector('.navbar__hamburger');
const sideBar        = document.querySelector('.sidebar');
const pageContent    = document.querySelector('.page-content');

// pri otevreni submenu v hlavnim menu -> maximalizovat leve menu
document.querySelectorAll('.sidebar-content .parent').forEach(el => {
	el.addEventListener('click', e => {
		if (pageContent) {
			pageContent.classList.remove('page-content--maximalize');
		}
	})
})

// logika pro zobrazeni pouze ikonek v hlavnim menu vlevo
menuMinimalize.addEventListener('click', () => {
	if (pageContent) {
		if (pageContent.classList.contains('page-content--maximalize')) {
			pageContent.classList.remove('page-content--maximalize');
			Cookies.remove('menu-minimalize');
		} else {
			pageContent.classList.add('page-content--maximalize');
			Cookies.set('menu-minimalize', '1');
		}
	}

	document.querySelectorAll('.sidebar-content .parent:not(.parent-active)').forEach(el => {
		const ul = el.querySelector('ul');
		if (ul.style.display === 'block') {
			ul.style.display = 'none';
		}

		el.querySelector('.arrow').classList.remove('opened');
	});
});

hamburger.addEventListener('click', () => {
	if (hamburger.classList.contains('navbar__hamburger--active')) {
		hamburger.classList.remove('navbar__hamburger--active');
		sideBar.classList.remove('sidebar--active');
	} else {
		hamburger.classList.add('navbar__hamburger--active');
		sideBar.classList.add('sidebar--active');
	}
});

if (checkMedia(1024)) {
	document.querySelectorAll('table').forEach(el => {
		el.classList.add('tablesaw');
		el.classList.add('tablesaw-stack');
		el.setAttribute('data-tablesaw-mode', 'stack');
	});

	Tablesaw.init();
}

document.querySelectorAll('[data-show-filters]').forEach(el => {
	el.addEventListener('click', () => {
		const filters = el.parentNode.parentNode.querySelector('.tr-filters');
		Utilities.toggleClass(filters, 'active');
		Utilities.toggleClass(el, 'active');
	})
});

// TODO staré řešení JS volá metodu v ajaxComplete. Při předělávání nezapomenou se napojit na najaComplete
window.fileRequest = (fileRequests) => {
	if (fileRequests === undefined)
		return;

	for (let i in fileRequests) {
		window.open(fileRequests[i].url, fileRequests[i].name);
	}
};

if (document.documentElement.dataset.rememberActiveLang === '0') {
	Cookies.remove('contentLang');
}

global.naja.addEventListener('before', e => {
	let loadingOverlay = document.getElementById('loading-overlay');

	if (loadingOverlay !== null) {
		loadingOverlay.dataset.count = parseInt(loadingOverlay.dataset.count) + 1;
	} else {
		document.getElementsByTagName('BODY')[0].insertAdjacentHTML('beforeend', '<div id="loading-overlay" data-count="1">' +
		                                                                         '<div class="spinner">' +
		                                                                         '<div class="rect1"></div>' +
		                                                                         '<div class="rect2"></div>' +
		                                                                         '<div class="rect3"></div>' +
		                                                                         '<div class="rect4"></div>' +
		                                                                         '<div class="rect5"></div>' +
		                                                                         '</div></div>');
	}
});

global.naja.addEventListener('complete', e => {
	let loadingOverlay = document.getElementById('loading-overlay');

	if (loadingOverlay) {
		if (loadingOverlay.dataset.count > 1)
			loadingOverlay.dataset.count = parseInt(loadingOverlay.dataset.count) - 1;
		else
			loadingOverlay.parentNode.removeChild(loadingOverlay);
	}

	if (e.response && e.response.fileRequests !== undefined) {
		window.fileRequest(e.response.fileRequests);
	}

	if (e.response['_datagrid_name'] && global.datagridPaginatorActiveElement && global.datagridPaginatorActiveElement.classList.contains('datagrid-paginator-link')) {
		const grid = document.querySelector('.datagrid-' + e.response['_datagrid_name']);

		if (grid) {
			setTimeout(() => {
				grid.scrollIntoView({behavior: "smooth"});
			}, 10);
		}

		global.datagridPaginatorActiveElement = null;
	}
});

// Kvůli kompatibilitě s jquery
window.jQuery(document).ajaxComplete(function (event, xhr, settings) {
	setTimeout(() => {
		document.querySelectorAll('[data-simplebar], [data-simplebar-lazy]').forEach(el => {
			new SimpleBar(el);
		});
	}, 250);

	const response = xhr.responseJSON || null;
	if (response) {
		if (response['_datagrid_name'] && global.datagridPaginatorActiveElement && global.datagridPaginatorActiveElement.classList.contains('datagrid-paginator-link')) {
			const grid = document.querySelector('.datagrid-' + response['_datagrid_name']);

			if (grid) {
				setTimeout(() => {
					grid.scrollIntoView({behavior: "smooth"});
				}, 5);
			}

			global.datagridPaginatorActiveElement = null;
		}
	}
});


document.querySelectorAll('[data-simplebar-lazy]').forEach(el => {
	if (window.performanceMode) {
		el.addEventListener('mouseenter', e => {
			if (el.inited === true)
				return;

			el.inited = true;
			new SimpleBar(el);
		});
	} else {
		new SimpleBar(el);
	}
});

const setValueByHtmlName = (response) => {
	if (response === undefined) {
		return;
	}

	if (response.data) {
		response = {...response, ...response.data};
	}

	if (response.setValueByHtmlName) {
		for (let name in response.setValueByHtmlName) {
			let input = document.querySelector('[name="' + name + '"]');

			if (input) {
				input.value = response.setValueByHtmlName[name];
			}
		}
	}

	if (response.setValueByHtmlId) {
		for (let elId in response.setValueByHtmlId) {
			let input = document.getElementById(elId);

			if (input) {
				input.value = response.setValueByHtmlId[elId];
			}
		}
	}

	if (response.setAttributeByHtmlId) {
		for (let elId in response.setAttributeByHtmlId) {
			let el = document.getElementById(elId);

			if (el) {
				for (let attr in response.setAttributeByHtmlId[elId]) {
					el.setAttribute(attr, response.setAttributeByHtmlId[elId][attr]);
				}
			}
		}
	}
};

const setSiteSelectByActiveTab = () => {
	let activeSite = document.querySelector('.tab-content__panel.active');
	if (activeSite) {
		activeSite = activeSite.dataset.site;

		if (!activeSite)
			return;

		document.querySelectorAll('[name="site"]:not([data-changed-by-tab])').forEach(input => {
			input.setAttribute('data-changed-by-tab', true);

			if (input.value == activeSite)
				return;

			setTimeout(() => {
				input.value = activeSite;
				input.dispatchEvent(new Event('change', {
					bubbles: true,
				}));
			}, 300);
		});
	}
}

const checkSwitchesHighlight = () => {
	if (window.performanceMode)
		return;

	document.querySelectorAll('.switch').forEach(switcher => {
		switchHighlightValue(switcher);
	});
}

// Přepínač addBool - zvýraznění zvolené hodnoty
const switchHighlightValue = (switcher) => {
	if (switcher.classList.contains('switch--bool')) {
		let input        = switcher.querySelector('input');
		let boolWatchers = input.dataset.disableWatcher === 'true' ? null : document.querySelectorAll('[data-watch-bool-input="' + input.id + '"]');
		let checked      = input.checked;
		let itemSuccess  = switcher.querySelector('.switch__item-1');
		let itemDanger   = switcher.querySelector('.switch__item-0');

		if (checked) {
			itemSuccess.classList.remove('bg-danger');
			itemDanger.classList.add('bg-success');

			if (boolWatchers)
				boolWatchers.forEach(watcher => {
					watcher.classList.add('bg-success');
					watcher.classList.remove('bg-danger');
				})
		} else {
			itemDanger.classList.remove('bg-success');
			itemSuccess.classList.add('bg-danger');

			if (boolWatchers)
				boolWatchers.forEach(watcher => {
					watcher.classList.remove('bg-success');
					watcher.classList.add('bg-danger');
				})
		}
	}
}

// bool switcher
const initBoolSwitcherControl = () => {
	document.querySelectorAll('.bool-switcher-control label:not(.init)').forEach(label => {
		label.classList.add('init');
		label.addEventListener('click', e => {
			let siblings = Utilities.getSiblings(label);

			siblings.forEach(sib => {
				sib.setAttribute('class', 'btn btn-outline-' + sib.dataset.btnClass);
			});

			label.setAttribute('class', 'btn btn-' + label.dataset.btnClass);
		});
	});
};

const initDataTextToggle = () => {
	document.querySelectorAll('[data-text-toggle]:not(.init)').forEach(el => {
		el.classList.add('init');
		el.addEventListener('click', e => {
			let tmp = el.textContent.trim();

			el.textContent        = el.dataset.textToggle.trim();
			el.dataset.textToggle = tmp;
		});
	});
};

const initDataGridNestedListChange = () => {
	document.querySelectorAll('.datagrid.has-auto-submit .nested-list input:not(.init)').forEach(input => {
		input.classList.add('init');

		input.addEventListener('change', e => {
			global.naja.uiHandler.submitForm(input.form);
		});
	});
};

// Init color pickeru
const initColorPicker = () => {
	document.querySelectorAll('[data-color-input="wrap"]:not(.init)').forEach(wrap => {
		wrap.classList.add('init');
		let input = wrap.querySelector('[data-color-input="input"]');

		let pickr = Pickr.create({
			el        : wrap.querySelector('[data-color-input="btn"]'),
			theme     : 'classic',
			default   : input.value || null,
			swatches  : [
				'#4c99ca',
				'#f5b252',
				'#30e4ef',
				'#4c4949',
				'#ff0000',
				'#f6f6f6',
				'#a1a1a1',
				'#cacaca',
				'#464444',
				'#39b54a',
				'#dadee0',
				'#8f8b8b',
			],
			components: {
				preview    : true,
				opacity    : true,
				hue        : true,
				interaction: {
					hex  : true,
					rgba : true,
					hsla : true,
					hsva : false,
					cmyk : false,
					input: true,
					clear: true,
					save : true
				}
			},
			strings   : {
				save : wrap.dataset.colorPickerTextSave,
				clear: wrap.dataset.colorPickerTextClear,
			}
		}).on('save', (color, instance) => {
			input.value = color ? color.toHEXA().toString() : '';
			instance.hide();
		});

		input.addEventListener('focus', e => {
			input.blur();
			pickr.show();
			setTimeout(() => {
				pickr.getRoot().interaction.result.focus();
			}, 200);
		});
	});
};

const initDataLinkOnChange = () => {
	document.querySelectorAll('[data-link-on-change]:not(.init)').forEach(el => {
		el.classList.add('init');
		el.addEventListener('change', e => {
			e.preventDefault();
			e.stopPropagation();

			const link = el.dataset.linkOnChange.replace('__val__', el.value);

			global.naja.makeRequest('post', link, {}, {
				history: false,
			});
		});
	});
};

const initSwitchContentLang = () => {
	if (global.performanceMode === true)
		return;

	if (document.querySelectorAll('.content-lang-switcher').length > 0) {
		let lang = document.querySelector('[name="selectedContentLang"]:checked').value;
		if (lang === undefined) {
			lang = document.querySelector('html').getAttribute('lang');

			const langClick = document.querySelector(`.content-lang-switcher input[value="'${lang}'"]`);
			langClick.click();
		}

		switchContentLang(lang);
	} else {
		let dataContentLangs = document.querySelectorAll('[data-content-lang]');
		let langs            = [];

		dataContentLangs.forEach(el => {
			if (!langs.includes(el.dataset.contentLang))
				langs.push(el.dataset.contentLang);
		});

		if (langs.length > 1) {
			dataContentLangs.forEach(el => {
				let wrapper = document.createElement('div');
				wrapper.classList.add('no-content-lang-switch');

				document.querySelectorAll('[data-content-lang]').forEach(elInput => {
					elInput.style.display = 'initial';
				});

				let title       = document.createElement('span');
				title.innerText = el.dataset.contentLang + ': ';
				wrapper.appendChild(title);

				el.parentNode.insertBefore(wrapper, el);
				wrapper.appendChild(el);
			});
		}
	}
};

let lastLangSet         = null;
global.lang             = lastLangSet;
const switchContentLang = (lang) => {
	if (document.documentElement.dataset.rememberActiveLang === '1') {
		Cookies.set('contentLang', lang);
	}

	document.querySelectorAll('[data-content-lang]').forEach(el => {
		const isEditor = el.nextElementSibling ? el.nextElementSibling.classList.contains('cke') : false;
		if (el.dataset.contentLang != lang) {
			if (isEditor) {
				el.nextElementSibling.style.display = 'none';
			} else {
				el.style.display = 'none';
			}
		} else {
			if (isEditor) {
				el.nextElementSibling.style.display = 'block';
			} else {
				el.style.display = 'block';
			}
		}

		const frmPair = el.closest('.frm__pair, .form-group, .article-editor-wrapper');
		if (frmPair) {
			let flag = frmPair.querySelector('.flag-icon');

			if (flag)
				flag.setAttribute('data-flag', lang);
		}
	});

	document.querySelectorAll('[data-show-lang]').forEach(el => {
		if (!el.dataset.showLang) {
			return;
		}

		try {
			const allowedLangs = JSON.parse(el.dataset.showLang);
			if (allowedLangs.indexOf(lang) !== -1) {
				el.style.display = 'block';
			} else {
				el.style.display = 'none';
			}
		} catch (e) {
		}
	});

	document.querySelectorAll('input[name="selectedContentLang"]').forEach(input => {
		if (input.value === lang) {
			input.checked = true;
		} else {
			input.checked = false;
		}
	})

	if (lastLangSet !== lang) {
		document.dispatchEvent(new CustomEvent('contentLangChange', {
			detail: {
				lang: lang,
			},
		}));
	}

	lastLangSet = lang;
	global.lang = lastLangSet;
};

const initButtonGridAction = () => {
	document.querySelectorAll('[data-grid-action]').forEach(el => {
		if (el.initedButtonGridAction === true)
			return;

		el.initedButtonGridAction = true;
		el.addEventListener('click', e => {
			e.preventDefault();
			let ids = [];
			document.querySelectorAll('[data-check="' + el.dataset.gridAction + '"]:checked').forEach(input => {
				let id = input.name.match(/\[(\d*)\]/)

				if (id)
					ids.push(id[1]);
			})

			if (ids.length) {
				global.naja.makeRequest('get', el.href, {
					status: el.dataset.status,
					ids   : ids,
				}, {
					history: false,
				});
			}
		});
	})
}

setSiteSelectByActiveTab();
initBoolSwitcherControl();
initDataTextToggle();
initDataGridNestedListChange();
initColorPicker();
checkSwitchesHighlight();
initDataLinkOnChange();
initSwitchContentLang();
initButtonGridAction();

// Kvůli kompatibilitě s jquery
window.jQuery(document).ajaxComplete(function (event, xhr, settings) {
	setValueByHtmlName(xhr.responseJSON);
	initBoolSwitcherControl();
	initDataTextToggle();
	initDataGridNestedListChange();
	initColorPicker();
	checkSwitchesHighlight();
	setSiteSelectByActiveTab();
	initDataLinkOnChange();
	initSwitchContentLang();
});

global.naja.addEventListener('complete', e => {
	setValueByHtmlName(e.response);
	initBoolSwitcherControl();
	initDataTextToggle();
	initDataGridNestedListChange();
	initColorPicker();
	checkSwitchesHighlight();
	setSiteSelectByActiveTab();
	initDataLinkOnChange();
	initSwitchContentLang();
});

const performanceModeSwitch = document.getElementById('performance-mode-switch__input');
if (performanceModeSwitch) {
	performanceModeSwitch.addEventListener('change', e => {
		global.naja.makeRequest('post', performanceModeSwitch.dataset.link, {
			val: performanceModeSwitch.checked === true ? 1 : 0,
		}, {
			history: false,
		}).then(e => {
			window.location.reload();
		});
	})
}

document.addEventListener('shownBsModal', e => {
	checkSwitchesHighlight();
});

document.addEventListener('click', e => {
	const target = e.target;

	/**
	 * Přepínač addBool
	 */
	if (target.classList.contains('switch__input')) {
		switchHighlightValue(target.parentElement);
	}

	/**
	 * Přepínač jazyka
	 */
	if (target.tagName === 'LABEL' && target.classList.contains('switch__item') && target.parentElement.classList.contains('content-lang-switcher__langs')) {
		switchContentLang(target.previousElementSibling.value);
	}
});
