import {slideDown, slideUp} from 'es6-slide-up-down';
import LiveFormValidation from 'live-form-validation-es6';

window.LiveForm = LiveFormValidation.LiveForm;
window.Nette    = LiveFormValidation.Nette;

LiveForm.setOptions({
	messageErrorClass : 'frm__input-error',
	messageErrorPrefix: '',
	wait              : 500
});

document.addEventListener('change', e => {
	if (e.target.dataset.toggle !== undefined) {
		const toggleTarget = document.getElementById(e.target.dataset.toggle);

		if (e.target.checked) {
			slideDown(toggleTarget);
		} else {
			slideUp(toggleTarget);
		}
	}
});
