<?php declare(strict_types = 1);

/**
 * [--composer-update] misto composer install provede update
 * [--no-acl] nebude aktualizovat opraveni
 * [--no-composer] neprovede zadny composer prikaz
 * [--no-npm] neprovede zadny npm prikaz
 * [--only-clear-cache] pouze promaze cache
 */

use Nette\Utils\FileSystem;
use Nette\Utils\Finder;
use Nette\Utils\Json;
use Nette\Utils\Strings;

require __DIR__ . '/../../autoload.php';

if (Strings::contains(getcwd(), 'pshkcms') && Strings::contains(getcwd(), 'core')) {
	$root   = '../../../';
	$cdRoot = 'cd ' . $root . ' &&';
} else {
	$root   = '';
	$cdRoot = '';
}

if (in_array('--phpstorm-pshkcms-vcs', $argv)) {
	echo '=================== LOAD PSHKCMS PACKAGES ===================' . PHP_EOL;
	$packagesList = [];
	foreach (glob(__DIR__ . '/../*', GLOB_ONLYDIR) as $dir) {
		$tmp     = explode('\\', realpath($dir));
		$package = array_pop($tmp);

		$packagesList[] = $package;
	}

	echo '=================== REMOVE EXCLUDE AND ADD SOURCE PATH ===================' . PHP_EOL;
	$projectName = basename(realpath(__DIR__ . '/../../../'));
	$xmlFile     = __DIR__ . '/../../../.idea/' . $projectName . '.iml';
	if (!file_exists($xmlFile)) {
		echo '=================== ERROR: PLEASE INIT PROJECT IN PHPSTORM ===================' . PHP_EOL;
		exit;
	}

	$xml = new DOMDocument();
	$xml->loadXML(file_get_contents($xmlFile));

	$module = null;
	foreach ($xml->getElementsByTagName('module') as $v) {
		/** @var DOMElement $v */
		if ($v->getAttribute('type') === 'WEB_MODULE' && $v->getAttribute('version') === '4') {
			$module = $v;
			break;
		}
	}

	if (!$module) {
		$module = $xml->createElement('module');
		$module->setAttribute('type', 'WEB_MODULE');
		$module->setAttribute('version', '4');
		$xml->appendChild($component);
	}

	$component = null;
	foreach ($module->getElementsByTagName('component') as $v) {
		/** @var DOMElement $v */
		if ($v->getAttribute('name') === 'NewModuleRootManager') {
			$component = $v;
			break;
		}
	}

	if (!$component) {
		$component = $xml->createElement('component');
		$component->setAttribute('name', 'NewModuleRootManager');
		$module->appendChild($component);
	}

	$content = null;
	foreach ($component->getElementsByTagName('content') as $v) {
		/** @var DOMElement $v */
		if ($v->getAttribute('url') === 'file://$MODULE_DIR$') {
			$content = $v;
			break;
		}
	}

	if (!$content) {
		$content = $xml->createElement('component');
		$content->setAttribute('url', 'file://$MODULE_DIR$');
		$component->appendChild($content);
	}

	// sources
	$existPackages = [];
	foreach ($content->getElementsByTagName('sourceFolder') as $v) {
		/** @var DOMElement $v */
		$url = $v->getAttribute('url');
		if (strpos($url, 'file://$MODULE_DIR$/vendor/pshkcms/') === 0) {
			$isTestSource = $v->getAttribute('isTestSource');
			if ($isTestSource !== 'false') {
				$v->setAttribute('isTestSource', 'false');
				$content->replaceChild($v, $v);
			}

			$tmp             = explode('/', $url);
			$existPackages[] = $tmp[5];
		}
	}

	foreach ($packagesList as $package) {
		if (!in_array($package, $existPackages)) {
			$v = $xml->createElement('sourceFolder');
			$v->setAttribute('url', 'file://$MODULE_DIR$/vendor/pshkcms/' . $package);
			$v->setAttribute('isTestSource', 'false');

			$content->appendChild($v);
		}
	}

	// exclude
	$forRemove = [];
	foreach ($content->getElementsByTagName('excludeFolder') as $v) {
		/** @var DOMElement $v */
		$url = $v->getAttribute('url');
		if (strpos($url, 'file://$MODULE_DIR$/vendor/pshkcms/') === 0) {
			$forRemove[] = $v;
		}
	}

	foreach ($forRemove as $v) {
		$content->removeChild($v);
	}

	file_put_contents($xmlFile, $xml->saveXML());
	echo '=================== PHPSTORM CONFIG FILE MODIFIED ===================' . PHP_EOL;

	echo '=================== ADD PSHKCMS PACKAGES TO PHPSTORM VCS ===================' . PHP_EOL;
	$xmlFile = __DIR__ . '/../../../.idea/vcs.xml';
	$xml     = new DOMDocument();

	if (file_exists($xmlFile)) {
		$xml->loadXML(file_get_contents($xmlFile));
	}

	/** @var DOMElement|null $project */
	$project = $xml->getElementsByTagName('project')[0] ?? null;
	if (!$project) {
		$project = $xml->createElement('project');
		$project->setAttribute('version', '4');

		$xml->appendChild($project);
	}

	$vcsComponent = null;
	foreach ($project->getElementsByTagName('component') as $component) {
		/** @var DOMElement $component */
		if ($component->getAttribute('name') === 'VcsDirectoryMappings') {
			$vcsComponent = $component;
			break;
		}
	}

	if (!$vcsComponent) {
		$vcsComponent = $xml->createElement('component');
		$vcsComponent->setAttribute('name', 'VcsDirectoryMappings');

		$project->appendChild($vcsComponent);

		$projectMapping = $xml->createElement('mapping');
		$projectMapping->setAttribute('directory', '$PROJECT_DIR$');
		$projectMapping->setAttribute('vcs', 'Git');
		$vcsComponent->appendChild($projectMapping);
	}

	$existPackages = [];
	foreach ($vcsComponent->getElementsByTagName('mapping') ?? [] as $mapping) {
		/** @var DOMElement $mapping */
		$directory = $mapping->getAttribute('directory');
		if (!$directory) {
			continue;
		}

		if (strpos($directory, '$PROJECT_DIR$/vendor/pshkcms') === 0) {
			$tmp             = explode('/', $directory);
			$existPackages[] = $tmp[3];
		}
	}

	foreach ($packagesList as $package) {
		if (!in_array($package, $existPackages)) {
			$mapping = $xml->createElement('mapping');
			$mapping->setAttribute('directory', '$PROJECT_DIR$/vendor/pshkcms/' . $package);
			$mapping->setAttribute('vcs', 'Git');

			$vcsComponent->appendChild($mapping);
		}
	}

	file_put_contents($xmlFile, $xml->saveXML());
	echo '=================== VCS FILE MODIFIED ===================' . PHP_EOL;
	exit;
}

echo '=================== CLEAR TEMP AND LOG ===================' . PHP_EOL;
foreach (['temp', 'log'] as $dir) {
	foreach (Finder::findDirectories('*')->in($root . $dir) as $file) {
		FileSystem::delete($file->getPathname());
	}
	foreach (Finder::findFiles('*')->in($root . $dir) as $file) {
		FileSystem::delete($file->getPathname());
	}
}

if (in_array('--only-clear-cache', $argv)) {
	return;
}

if (!in_array('--no-composer', $argv)) {
	if (in_array('--composer-update', $argv)) {
		echo '=================== COMPOSER UPDATE ===================' . PHP_EOL;
		shell_exec(sprintf('%s composer update', $cdRoot));
	} else {
		echo '=================== COMPOSER INSTALL ===================' . PHP_EOL;
		shell_exec(sprintf('%s composer install', $cdRoot));
	}
}

$v = $root === '' ? 'vendor' : ($root . 'vendor');
if (file_exists($v . '/brainmaestro/composer-git-hooks')) {
	echo '=================== UPDATE BINDING GIT HOOKS ===================' . PHP_EOL;
	foreach (Finder::findFiles('composer.json')->from($v . '/pshkcms') as $composerFile) {
		try {
			$composer = Json::decode(file_get_contents($composerFile->getPathname()), Json::FORCE_ARRAY);
			if (isset($composer['extra']['hooks'])) {
				echo 'PACKAGE ' . $composerFile->getPath() . PHP_EOL;
				echo shell_exec(sprintf('cd %s && php ../../bin/cghooks update', $composerFile->getPath()));
			}
		} catch (Exception $exception) {
		}
	}
}

if (!in_array('--no-acl', $argv)) {
	echo '=================== UPDATE ACL ===================' . PHP_EOL;
	echo shell_exec(sprintf('%s php bin/console users:update-acl', $cdRoot));
}

echo '=================== MIGRATIONS ===================' . PHP_EOL;
echo shell_exec(sprintf('%s php bin/console migrations:migrate --no-interaction', $cdRoot));

if (!in_array('--no-npm', $argv)) {
	echo '=================== NPM INSTALL ===================' . PHP_EOL;
	echo shell_exec(sprintf('%s npm install', $cdRoot));
	echo '=================== NPM RUN ADMIN-INSTALL ===================' . PHP_EOL;
	echo shell_exec(sprintf('%s npm run admin-install', $cdRoot));
	exit;
}
