<?php declare(strict_types = 1);

namespace Core\AdminModule\Model;

use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Event\Event;
use Core\Model\Event\EventDispatcher;
use Nette\Utils\FileSystem;
use Nette\Utils\Json;

class EditorDataService
{
	protected EntityManagerDecorator $em;
	protected EventDispatcher        $eventDispatcher;

	public function __construct(
		EntityManagerDecorator $em,
		EventDispatcher        $eventDispatcher
	)
	{
		$this->em              = $em;
		$this->eventDispatcher = $eventDispatcher;
	}

	public function runCheck(): array
	{
		$dataEvent = new Event(['data' => []]);

		$this->eventDispatcher->dispatch($dataEvent, 'core.content.loadEditorData');

		$this->eventDispatcher->dispatch($dataEvent, 'core.content.checkMissingEditorData');

		$dataForSave = [];
		foreach ($dataEvent->data['data'] as $row) {
			if ($row['missingData']) {
				unset($row['content']);

				$dataForSave[] = $row;
			}
		}

		FileSystem::write(DATA_DIR . '/core/content/missing_editor_data.json', Json::encode($dataForSave));

		return $dataForSave;
	}
}
