<?php declare(strict_types = 1);

namespace Core\ApiModule\Api\V1\Controllers;

use Apitte\Core\Annotation\Controller\Path;
use Apitte\Core\Annotation\Controller\Method;
use Apitte\Core\Annotation\Controller\RequestParameter;
use Apitte\Core\Annotation\Controller\RequestParameters;
use Apitte\Core\Http\ApiRequest;
use Apitte\Core\Http\ApiResponse;
use Core\Model\Images\ImagePipe;
use Nette\Utils\Strings;
use Nette\Utils\Validators;

/**
 * @Path("/images")
 */
class ImagesController extends BaseController
{
	protected ImagePipe $imagePipe;

	public function __construct(ImagePipe $imagePipe)
	{
		$this->imagePipe = $imagePipe;
	}

	/**
	 * @Path("/get")
	 * @Method("GET")
	 * @RequestParameters({
	 *      @RequestParameter(name="path", type="string", required=false, in="query", allowEmpty=true),
	 *      @RequestParameter(name="size", type="string", required=false, in="query"),
	 *      @RequestParameter(name="flags", type="string", required=false, in="query")
	 * })
	 */
	public function get(ApiRequest $request, ApiResponse $response): ApiResponse
	{
		$img = null;
		$path = $request->getParameter('path');
		$size = $request->getParameter('size');
		$flags = $request->getParameter('flags');

		$size = Strings::contains((string) $size, 'x') ? $size : null;

		$img['src'] = Validators::isNone($path) ? '' : $this->imagePipe->request($path, $size, $flags);
		if ($size) {
			[$w, $h] = explode('x', $size);
			$img['width'] = (int) $w;
			$img['height'] = (int) $h;
		}

		return $response->writeJsonBody(['img' => $img])->withStatus(ApiResponse::S200_OK);
	}

}