<?php declare(strict_types = 1);

namespace Core\ApiModule\Model\Middlewares;

use Contributte\Middlewares\IMiddleware;
use Core\Model\Event\ApiShutdownEvent;
use Core\Model\Event\EventDispatcher;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

class ShutdownMiddleware implements IMiddleware
{
	protected EventDispatcher $eventDispatcher;

	public function __construct(
		EventDispatcher $eventDispatcher
	)
	{
		$this->eventDispatcher = $eventDispatcher;
	}

	public function __invoke(ServerRequestInterface $request, ResponseInterface $response, callable $next): ResponseInterface
	{
		$response = $next($request, $response);

		$event = new ApiShutdownEvent($request, $response);
		$this->eventDispatcher->dispatch($event, ApiShutdownEvent::class);

		return $response;
	}
}
