<?php declare(strict_types = 1);

namespace Core\Components\Header;

use Core\FrontModule\Model\SeoParser;
use Core\Model\Sites;
use Core\Model\UI\BaseControl;
use Nette\Utils\Html;

class Title extends BaseControl
{
	protected SeoParser $seoParserService;
	protected Sites     $sites;

	protected ?string $title           = null;
	protected bool    $includeSiteName = true;

	/** @var null|Html|string */
	protected $colonText = null;

	public function __construct(
		SeoParser $seoParser,
		Sites     $sites
	)
	{
		$this->seoParserService = $seoParser;
		$this->sites            = $sites;
	}

	public function render(): void
	{
		$this->template->title     = trim(strip_tags($this->getFullTitle()));
		$this->template->colonText = $this->colonText ?: '';

		$this->template->render(__DIR__ . '/Title.latte');
	}

	/*******************************************************************************************************************
	 * ======================== Setters
	 */

	public function setTitle(string $title, bool $includeSiteName = true): void
	{
		$this->title           = $title;
		$this->includeSiteName = $includeSiteName;

		if ($this->presenter && $this->presenter->isAjax()) {
			$this->presenter->payload->pageTitle = $this->getFullTitle();
		}
	}

	public function setColonText(?string $text = null): void
	{
		$this->colonText = $text
			? Html::el('span class=font-weight-light')->setText($text)
			: null;
	}

	/*******************************************************************************************************************
	 * ======================== Getters
	 */

	public function getTitle(): string { return $this->seoParserService->parse(trim("$this->title $this->colonText")); }

	public function getFullTitle(): string
	{
		$site = $this->sites->getCurrentSite();

		if ($this->includeSiteName) {
			$title = $this->title;
		} else {
			$title = $this->title
				? $this->title . ($this->colonText ? ': ' . $this->colonText : '') . sprintf(' %s %s', $site->getSiteNameSeparator(), $site->getSiteName())
				: $site->getSiteName();
		}

		return $this->seoParserService->parse(trim((string) $title));
	}
}
