<?php declare(strict_types = 1);

namespace Core\Components\Redesign;

use Core\FrontModule\Model\Redesign;
use Core\Model\UI\BaseControl;
class RedesignSwitcher extends BaseControl
{
	protected Redesign $redesign;

	public function __construct(Redesign $redesign)
	{
		$this->redesign = $redesign;
	}

	public function render(string $mod = null): void
	{
		$this->template->mod = $mod;
		$this->template->isEnabled = $this->redesign::isEnabled();
		$this->template->isAllowed = $this->isAllowed();
		$this->template->render($this->getTemplateFile());
	}

	public function handleSwitch(): void
	{
		$this->redesign->switch();
		$this->redirect('this');
	}

	public function isAllowed(): bool
	{
		return $this->redesign->isSwitcherAllowed();
	}

}