<?php declare(strict_types = 1);

namespace Core\FrontModule\Components\StructureData;

use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\Helpers\Strings;
use Core\Model\UI\BaseControl;
use Spatie\SchemaOrg\BaseType;
use Spatie\SchemaOrg\Schema;

class DataSchema extends BaseControl
{
	/** @var BaseType[] */
	protected array $schemas = [];

	public function render(): void
	{
		if (!empty($this->presenter->template->breadcrumb ?? [])) {
			$list    = [];
			$i       = 1;
			$baseUrl = $this->presenter->baseUrl;

			foreach ($this->presenter->template->breadcrumb as $nav) {
				$link = is_array($nav->link) ? $nav->link[0] : $nav->link;

				/** @var DaoNavigationItem $nav */
				$item = Schema::listItem()
					->position($i)
					->name($nav->title)
					->item(Strings::startsWith((string) $link, 'http') ? $link : $baseUrl . ltrim((string) $link, '/'));

				$list[] = $item;
				$i++;
			}

			$this->addSchema(Schema::breadcrumbList()->itemListElement($list));
		}

		if (empty($this->schemas)) {
			return;
		}

		$this->template->schemas = $this->schemas;
		$this->template->render(__DIR__ . "/DataSchema.latte");
	}

	public function addSchema(BaseType $schema): void
	{
		$this->schemas[] = $schema;
	}
}
