<?php declare(strict_types = 1);

namespace Core\FrontModule\Model;

use Core\Model\BotDetect;
use Core\Model\Http\Session;
use Nette\Http\SessionSection;

class ABTest
{
	public static string $defaultDir = DATA_DIR . '/core/ab-test/';

	protected SessionSection $sessionSection;

	protected array $cVariants = [];

	public function __construct(
		Session $session
	)
	{
		$this->sessionSection = $session->getSection('core/ab-test');
	}

	public function setVariant(string $key, string $variant): void
	{
		if (!in_array($variant, ['A', 'B'], true)) {
			throw new \InvalidArgumentException('Variant must be either "A" or "B".');
		}

		$this->sessionSection->set($key, $variant, '1 month');
		$this->cVariants[$key] = $variant;
	}

	public function getActive(): array
	{
		return (array) $this->sessionSection->getIterator() ?: [];
	}

	public function getVariant(string $key): string
	{
		if (BotDetect::isBot()) {
			return 'A';
		}

		if (!array_key_exists($key, $this->cVariants)) {
			/** @var ?string $variant */
			$variant = $this->sessionSection->get($key);

			if (!$variant) {
				$variant = $this->getNextVariant($key);

				$this->sessionSection->set($key, $variant, '1 month');
			}

			$this->cVariants[$key] = $variant;
		}

		return $this->cVariants[$key];
	}

	protected function getNextVariant(string $key): string
	{
		$file = self::$defaultDir . '/' . $key . '.txt';

		$last = is_file($file) ? trim((string) file_get_contents($file)) : 'B';
		$next = $last === 'A' ? 'B' : 'A';
		file_put_contents($file, $next, LOCK_EX);

		return $next;
	}

}
