<?php declare(strict_types = 1);

namespace Core\FrontModule\Model;

use Contributte\Translation\Translator;
use Core\Model\Lang\Langs;
use Core\Model\Sites;
use Core\Model\SystemConfig;
use Nette\Http\IRequest;
use Nette\Http\IResponse;
use Nette\Security\User;
use Nette\Utils\Arrays;

class Redesign
{
	protected IRequest $request;
	protected IResponse $response;
	protected Sites $sites;
	protected User $user;
	protected Translator $translator;
	protected static bool $isEnabled = false;
	protected const cookieKey = 'redesign-switcher';

	public function __construct(IRequest $request, IResponse $response, Sites $sites, User $user, Translator $translator)
	{
		$this->request = $request;
		$this->response = $response;
		$this->sites = $sites;
		$this->user = $user;
		$this->translator = $translator;

		$allowedLangs = SystemConfig::load('redesign.langs', []);
		static::$isEnabled = ($this->request->getCookie(self::cookieKey) === 'on' || $this->request->getQuery('redesign') === '1')
			&& (!$allowedLangs || in_array($this->translator->getLocale(), $allowedLangs, true));
	}

	public function isSwitcherAllowed(): bool
	{
		if (!SystemConfig::load('redesign.enable')) {
			return false;
		}

		$allowedLangs = SystemConfig::load('redesign.langs', []);
		if ($allowedLangs && !in_array($this->translator->getLocale(), $allowedLangs, true)) {
			return false;
		}

		$site = $this->sites->getCurrentSite();
		$siteIdent = $site->getIdent();
		$allowedSites = SystemConfig::load('redesign.sites', []);
		if ($allowedSites && !in_array($siteIdent, $allowedSites, true)) {
			return false;
		}

		$isAllowedRole = Arrays::some(
			SystemConfig::load('redesign.roles', []),
			fn($role) => $this->user->isInRole($role)
		);
		if ($isAllowedRole) {
			return true;
		}

		$ipRestrict = SystemConfig::load('redesign.fallback.ipRestrict', []);
		if (!$ipRestrict) {
			return false;
		}

		$currentIp = $_SERVER['REMOTE_ADDR'];
		if (in_array($currentIp, $ipRestrict, true)) {
			return true;
		}

		return false;
	}

	public function switch(): void
	{
		$this->response->setCookie(self::cookieKey, static::$isEnabled ? 'off' : 'on', '1 week');
	}

	public static function isEnabled(): bool
	{
		if (!SystemConfig::load('redesign.enable')) {
			return false;
		}

		return static::$isEnabled;
	}

}