<?php declare(strict_types = 1);

namespace Core\FrontModule\Model\Subscribers;

use Core\FrontModule\Model\Redesign;
use Core\Model\Event\ControlEvent;
use Core\Model\Event\Event;
use Core\Model\Event\EventDispatcher;
use Core\Model\UI\ErrorPresenter;
use Core\Model\UI\FrontPresenter;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class RedesignSubscriber implements EventSubscriberInterface
{
	protected EventDispatcher $eventDispatcher;

	public function __construct(EventDispatcher $eventDispatcher)
	{
		$this->eventDispatcher = $eventDispatcher;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			FrontPresenter::class . '::startup'      => 'onRedesign',
			ErrorPresenter::class . '::startup'      => 'onRedesign',
			FrontPresenter::class . '::beforeRender' => 'onRedesign',
			ErrorPresenter::class . '::beforeRender' => 'onRedesign'
		];
	}

	public function onRedesign(ControlEvent $event): void
	{
		if (Redesign::isEnabled()) {
			$this->eventDispatcher->dispatch(new Event, 'redesign.onEnabled');
		}
	}

}