<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\Migrations\Finder\Finder;
use Doctrine\Migrations\Finder\MigrationDeepFinder;
use FilesystemIterator;
use Nette\Neon\Neon;
use RecursiveDirectoryIterator;
use RecursiveIteratorIterator;
use RegexIterator;

class MigrationFinder extends Finder implements MigrationDeepFinder
{
	/**
	 * @return string[]
	 */
	public function findMigrations(string $directory, ?string $namespace = null): array
	{
		$dir    = $this->getRealPath($directory);
		$result = [];

		// Načtení aktivních rozšíženích ze systému
		$fileContent = file_get_contents(APP_DIR . '/config/app/cms.neon');
		if (!$fileContent) {
			return [];
		}

		$neon = Neon::decode($fileContent);
		foreach ($neon['extensions'] as $name => $class) {
			$dir      = SRC_DIR . '/' . strtolower($name) . '/src/migrations';
			$dirName2 = explode('\\', $class)[0] ?? '';

			if (!file_exists($dir)) {
				$dir = SRC_DIR . '/' . strtolower($dirName2) . '/src/migrations';
			}

			if (!file_exists($dir)) {
				$dir = CUSTOM_DIR . '/' . strtolower($name) . '/migrations';
			}

			if (!file_exists($dir) && $dirName2) {
				$dir = CUSTOM_DIR . '/' . $dirName2 . '/migrations';
			}

			if (file_exists($dir)) {
				$result += $this->loadMigrations(
					$this->getMatches($this->createIterator($dir)),
					$namespace
				);
			}

			$dir = CUSTOM_DIR . '/' . ucfirst($name) . '/migrations';
			if (file_exists($dir)) {
				$result += $this->loadMigrations(
					$this->getMatches($this->createIterator($dir)),
					$namespace
				);
			}
		}

		return $result;
	}

	private function createIterator(string $dir): RegexIterator
	{
		return new RegexIterator(
			new RecursiveIteratorIterator(
				new RecursiveDirectoryIterator($dir, FilesystemIterator::SKIP_DOTS | FilesystemIterator::FOLLOW_SYMLINKS),
				RecursiveIteratorIterator::LEAVES_ONLY
			),
			$this->getPattern(),
			RegexIterator::GET_MATCH
		);
	}

	private function getPattern(): string
	{
		return sprintf(
			'#^.+\\%sVersion[^\\%s]{1,255}\\.php$#i',
			DIRECTORY_SEPARATOR,
			DIRECTORY_SEPARATOR
		);
	}

	/**
	 * @return string[]
	 */
	private function getMatches(RegexIterator $iteratorFilesMatch): array
	{
		$files = [];
		foreach ($iteratorFilesMatch as $file) {
			$files[] = $file[0];
		}

		return $files;
	}
}
