<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="core__public_holiday")
 * @ORM\Entity
 * @ORM\EntityListeners({"Core\Model\Entities\TranslateListener"})
 */
class PublicHoliday
{
	use TTranslateListener;
	use TId;

	/**
	 * @ORM\Column(type="date", nullable=false, unique=true)
	 */
	public \DateTime $date;

	/**
	 * @var Collection<string, PublicHolidayText>
	 * @ORM\OneToMany(targetEntity="PublicHolidayText", mappedBy="publicHoliday", indexBy="lang")
	 */
	public Collection $texts;

	/**
	 * @ORM\ManyToOne(targetEntity="Country")
	 * @ORM\JoinColumn(referencedColumnName="id", onDelete="SET NULL", nullable=true)
	 */
	public ?Country $country = null;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $source = null;

	public function __construct(\DateTime $date)
	{
		$this->date  = $date;
		$this->texts = new ArrayCollection();
	}

	public function getText(?string $lang = null): ?PublicHolidayText { return $this->texts[$lang ?: $this->locale] ?? null; }

	/** @return Collection<string, PublicHolidayText> */
	public function getTexts() { return $this->texts; }
}
