<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\Json;

/**
 * @ORM\Table(name="core__setting")
 * @ORM\Entity
 */
class Setting
{

	/**
	 * @ORM\Id
	 * @ORM\Column(name="`key`", type="string", length=255, nullable=false)
	 */
	public string $key;

	/**
	 * @var string
	 * @ORM\Column(name="`value`", type="text", nullable=true)
	 */
	public $value;

	/**
	 * @param mixed $value
	 */
	public function __construct(string $key, $value)
	{
		$this->key = $key;
		$this->setValue($value);
	}

	/**
	 * @param string|array|\DateTimeInterface|int $value
	 */
	public function setValue($value): void
	{
		if (is_array($value)) {
			$value = Json::encode($value);
		}

		if ($value instanceof \DateTimeInterface) {
			$value = $value->format('d.m.Y H:i');
		}

		$this->value = (string) $value;
	}
}
