<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="core__translate_field")
 * @ORM\Entity
 */
class TranslateField
{

	/**
	 * @ORM\Id
	 * @ORM\Column(name="`key`", type="string", length=255, nullable=false)
	 */
	public string $key;

	/**
	 * @ORM\Id
	 * @ORM\Column(name="`locale`", type="string", length=255, nullable=false)
	 */
	public string $locale;

	/**
	 * @ORM\Column(name="is_locked", type="smallint", nullable=false, options={"default"=0})
	 */
	public int $isLocked = 0;
}
