<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Users\Model\Entities\User;

/**
 * @ORM\Table(name="core__translate_log")
 * @ORM\Entity
 */
class TranslateLog
{
	use TIdUnsigned;

	/**
	 * @ORM\Column(name="source_locale", type="string", length=2, nullable=false)
	 */
	public string $sourceLocale;

	/**
	 * @ORM\Column(name="target_locale", type="string", length=2, nullable=false)
	 */
	public string $targetLocale;

	/**
	 * @ORM\Column(name="source_text", type="text", nullable=false)
	 */
	public string $sourceText;

	/**
	 * @ORM\Column(name="target_text", type="text", nullable=false)
	 */
	public string $targetText;

	/**
	 * @ORM\ManyToOne(targetEntity="Users\Model\Entities\User")
	 * @ORM\JoinColumn(name="user", referencedColumnName="id", onDelete="SET NULL", nullable=true)
	 */
	public ?User $userId = null;

	/**
	 * @ORM\Column(name="user_email", type="string", length=255, nullable=true)
	 */
	public ?string $userEmail = null;

	/**
	 * @ORM\Column(name="billed_characters", type="integer", nullable=false, options={"default"=0, "unsigned"=true})
	 */
	public int $billedCharacters = 0;

	/**
	 * @ORM\Column(name="created_at", type="datetime", nullable=false, options={"default"="CURRENT_TIMESTAMP"})
	 */
	public \DateTime $createdAt;
}
